@extends('template.template_gpt')
@section('body')

<div class="page-content">
    <div class="container-fluid" id="app" >

        <div class="card card-bordered mt-3">
            <div class="card-inner p-4">
                <div class="row ">

                    <div class="col-md-5">

                        <div class="form-group"> 
                            <label for="">Pregunta</label> <button @click="activarNuevaPregunta" class="btn btn-sm btn-success">Agregar</button>
                            <input v-model="pregunta"  type="text" class="form-control">
                        </div>

                        <div class="form-group">
                            <label for="">Respuesta</label>
                                <textarea v-model="respuesta" name="" id="" cols="30" rows="10" class="form-control"></textarea>
                        </div>

                        <span v-if="tp_nueva_pregunta == 0">
                            <button v-if="tp_activo == 1" @click="OptionPregunta(0)"  class="btn btn-md btn-warning btn-block form-group  mt-1">Desactivar</button>
                            <button v-if="tp_activo == 0 && id_point " @click="OptionPregunta(1)"  class="btn btn-md btn-success btn-block form-group  mt-1">Activar</button>
                        </span>
                        
                        <button @click="UpdateCreatePregunta()" class="btn sm btn-primary btn-block mt-1" v-text="txt_update_create"></button>
                        
                    </div>

                    <div class="col-md-7">

                        <div class="row">
                            
                        <div class="col-sm-4">
                            <h4 class="card-title">
                                <div class="form-group">
                                    <label for="">Filtro</label>
                                    <select class="form-control" v-model="filtro_search" @change="getPreguntas()">
                                        <option value="1">Activo</option>
                                        <option value="0">Obsoleto</option>
                                    </select>
                                </div>
                            </h4>
                        </div>

                        </div>

                        <div class="row" v-for="(item,index) in conocimiento">
                            <div class="col-md-12">
                                <div class="accordion" id="accordionExample">
                                    <div class="accordion-item mt-2 mb-4" >
                                        <h2 @click="selectPregunta(item.id)" class="accordion-header" :id="'item-'+(item.id)">
                                            <button class="accordion-button fw-medium" type="button" data-bs-toggle="collapse" :data-bs-target="'#accordion-item-2-'+(item.id)" aria-expanded="true" :aria-controls="'item-'+(item.id)">
                                            <span v-if="item.tp_obsoleto == 1" > (Obsoleto)</span> @{{ '#'+(item.id)+' '+item.pregunta}}
                                            </button>
                                        </h2>
                                        <div :id="'accordion-item-2-'+(item.id)" class="accordion-collapse collapse " aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                                <div class="text-muted">
                                                    <div v-html="formatLinks(item.respuesta.slice(0,1000))"></div>
                                                </div>

                                                <button  @click="OptionPregunta(1)" v-if="item.tp_obsoleto == 1"  class="btn btn-md btn-success btn-block form-group ">Activar</button>

                                            </div>
                                        </div>
                                    </div>
                                
                                </div>
                            </div>
                        </div>

                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="getPreguntas(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActived ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="getPreguntas(page)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="getPreguntas(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>

                    </div>

                </div>
            </div>
        </div>

    </div>

</div>
<script type="text/javascript">
        
        Vue.component('QuillEditor', VueQuill.QuillEditor);
        var app = new Vue({
                el: '#app',
                data: {
                    filtro_search       : 1,
                    respuesta           : '',
                    myEditor            : [],
                    conocimiento        : [],
                    largo_caracteres    : 500,
                    pregunta            : '',
                    id                  : '',
                    editor              : null,
                    options: {
                                        modules: {toolbar: ['bold', 'italic', 'underline']},
                                        placeholder: '',
                                        theme: 'snow'
                    },
                    array_annos         : [],
                    largo_preguntas     : 0,
                    largo_validacion    : 0,
                    nr_mes_actual       : 0,
                    nr_anno_actual      : 0,
                    tp_nueva_pregunta   : 1,
                    search_pregunta     : '',
                    array_meses         : ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'],
                    txt_update_create   : 'Guardar',
                    id_point            : 0,
                    tp_activo           : 0,
                    pagination          : {
                                            'total' : 0,
                                            'current_page' : 0,
                                            'per_page' : 0,
                                            'last_page' : 0,
                                            'from' : 0,
                                            'to' : 0,
                                        },
                    offset              : 3,

                },
                components: {},
                filters:{},
                computed:{
                    isActived: function()
                    {
                        return this.pagination.current_page;
                    },
                    pagesNumber: function() 
                    {
                        if(!this.pagination.to) 
                            return [];

                        var from = this.pagination.current_page - this.offset;
                        if(from < 1)
                            from = 1;

                        var to = from + (this.offset * 2);
                            to = this.pagination.last_page;

                        var pagesArray = [];
                        while(from <= to) {
                            pagesArray.push(from);
                            from++;
                        }
                        return pagesArray;

                    }
                },
                methods: {
                OptionPregunta(tp_status)
                {
                    let me      = this;
                    let data    = 
                                    {
                                        id          : me.id_point,
                                        tp_status   : tp_status,
                                    }

                    axios.post('/preguntas/option',data)
                    .then(function(response)
                    {
                        let resp = response.data
                        me.modalSweetAlert({title: resp.title,text: resp.msj,icon: resp.color})
                        me.getPreguntas(me.pagination.current_page)
                        me.pregunta = ''
                        me.respuesta = ''
                    })
                },
                formatLinks(text) 
                {
                    const regex = /\[(.*?)\]\((.*?)\)/g;
                    const replacedText = text.replace(regex, '<a target="_blank" href="$2">Enlace</a>');
                    return replacedText;
                },
                modalSweetAlert(resp)
                {
                    Swal.fire({
                                title: resp.title,
                                text: resp.text,
                                icon: resp.icon,
                                confirmButtonText: 'Cerrar'
                                })
                },
                validacionPregunta()
                {
                    let me = this;
                    let cond = 0;


                    if(me.tp_nueva_pregunta == 1)
                    {
                        me.respuesta = me.respuesta

                        
                        if(me.pregunta.length == 0 || me.respuesta.length <=10)
                        {
                            me.modalSweetAlert({
                                title   : 'Error',
                                text    : 'Favor Ingresar Pregunta y Respuesta(Min 10 Caracteres)',
                                icon    : 'error'
                            })
                            cond  = 1
                        }
                    }

                    if(me.tp_nueva_pregunta == 0)
                    {

                        if(me.pregunta.length == 0)
                        {
                            me.modalSweetAlert({
                                title   : 'Error',
                                text    : 'Favor Seleccionar Pregunta',
                                icon    : 'error'
                            })
                            return 1
                        }

                        if( me.respuesta.length <=10)
                        {
                            me.modalSweetAlert({
                                title   : 'Error',
                                text    : 'Favor Ingresar Respuesta(Min 10 Caracteres)',
                                icon    : 'error'
                            })
                            cond = 1
                        }
                    }

                    return cond

                },  
                UpdateCreatePregunta()
                {
                    let me = this;
                    let validacion = me.validacionPregunta();

                    if(validacion ) return

                    let data = 
                                {
                                    pregunta            : me.pregunta,
                                    respuesta           : me.respuesta,
                                    tp_nueva_pregunta   : me.tp_nueva_pregunta,
                                    tp_activo           : me.filtro_search,
                                    id                  : me.id_point,
                                }

                    axios.post('/preguntas/set',data)
                    .then(function(response)
                    {
                        let resp = response.data
                        me.modalSweetAlert({title: resp.title,text: resp.msj,icon: resp.icon})
                        me.getPreguntas(me.pagination.current_page)
                        me.tp_nueva_pregunta = 0
                    })
                },
                activarNuevaPregunta()
                {
                    let me          = this
                    //this.myEditor.setHTML('')
                    me.respuesta    = ''
                    me.pregunta     = ''
                    me.tp_nueva_pregunta = 1
                    me.txt_update_create = 'Crear Pregunta'
                },
                selectPregunta(id_pregunta)
                {
                    let me = this;

                    me.id_point = id_pregunta

                    if(id_pregunta == null) return

                    me.tp_nueva_pregunta = 0

                    let tmp_pregunta = me.conocimiento.filter(function(item)
                    {
                        return item.id == id_pregunta
                    })[0]

                    me.tp_nueva_pregunta    = 0

                    me.respuesta            = tmp_pregunta.respuesta
                    me.pregunta             = tmp_pregunta.pregunta
                    me.tp_activo            = tmp_pregunta.tp_activo

                    me.txt_update_create    = 'Actualizar Pregunta'


                    //this.myEditor.setHTML(me.respuesta)            
                },
                
                getPreguntas(pagina=1)
                {
                    let me              = this;
                    me.largo_preguntas  = 0
                    me.conocimiento     = []

                    axios.post('/preguntas',{
                        pagina          : pagina,
                        filtro_search   : me.filtro_search,
                        search_pregunta : me.search_pregunta
                    })
                        .then(function(response)
                        {
                            let resp            = response.data

                            if(resp.error == 1)
                            {
                                me.modalSweetAlert({title: 'Error',text: resp.msj,icon: 'error'})
                                return
                            }

                            me.conocimiento     = resp.data
                            me.largo_preguntas  = resp.total;
                            me.pagination       = resp.pagination

                        })
                }
            },

            mounted() {

                this.getPreguntas()
               
            }
        });
    </script>
<style lang="">
    
</style>
@endsection()


