<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="theme-color" content="#0969C2" />
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Las Condes</title>
	<!-- Fonts -->
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/css/all.min.css" rel="stylesheet" />
	<!-- Styles -->
	<link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
	<link href="{{ asset('css/app.css') }}?ver=20200529" rel="stylesheet">
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=UA-168909574-1"></script>
	<script src="{{ asset('js/funciones_generales.js') }}"></script>

	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());
		gtag('config', 'UA-168909574-1');
	</script>
	<style>
		.modal-body
		{
    max-height: calc(100vh - 200px);
    overflow-y: auto;
		}
	</style>
</head>

<body>
	<div id="app" class="layout">
		<!-- Main Manu -->
		<div class="menu">
			<div class="menu__logo">
				<img class="img-fluid" src="{{ENV('BILLETERA_LOGO','/img/logo-las_condes.png')}}" alt="Las Condes">
			</div>
			<div class="menu__list">
				@role(['Vecino'])
				@if(Auth::user()->terminos)

				@endif
				@endrole
				@role(['Comercio'])


				@endrole

				@role(['Votacion'])
				<a href="{{route('votacion.listado')}}" class="menu__item {{(request()->is('parques/ingreso')) ? 'active' : '' }}">
					<span class="menu__item-icon">
            <i class="fas fa-vote-yea"></i>
					</span>
					<span class="menu__item-title">
						Conteo Votos
					</span>
				</a>
				<a href="{{route('beneficiarios.historial.constituido')}}" class="menu__item {{(request()->is('parques/ingreso')) ? 'active' : '' }}">
					<span class="menu__item-icon">
            <i class="fas fa-chalkboard"></i>
					</span>
					<span class="menu__item-title">
						Mesas Constituidas
					</span>
				</a>

				@endrole
			</div>
		</div>
		<div class="wrapper">
			<!-- Header -->
			<div class="wrapper__header">
				<nav class="navbar">
					<a class="navbar-brand d-md-none text-white" href="{{ url('/') }}">
						<img class="img-fluid" src="{{ENV('BILLETERA_LOGO','/img/logo-las_condes.png')}}">
					</a>
					<div class="wrapper__header-profile">
						<div class="dropdown">
							<button id="profile" class="btn dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<span class="wrapper__header-icon">
									<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 508 508" style="enable-background:new 0 0 508 508;" xml:space="preserve">
										<path class="icon-bg" d="M254,0C113.7,0,0,113.7,0,254c0,75.7,33.1,143.7,85.7,190.3C130.6,483.9,189.5,508,254,508
											c64.6,0,123.5-24.1,168.3-63.8C474.9,397.7,508,329.7,508,254C508,113.7,394.3,0,254,0z"/>
										<path class="icon-user" d="M402.4,423.6c-13-9.7-36.6-25.8-62.3-37.7c-25.7-11.8-40.8-39.5-36.7-67.4c0-0.4,0.1-0.8,0.2-1.3
											c0,0,58.5-39.6,50.4-78.2c0,0,1.8,0.1,4.5-0.1c25.8-2.4,27.4-40.8,1.9-44.9c-0.2,0-0.5-0.1-0.7-0.1l-0.8-4.2
											c7.8-27.3,26.8-110-30.7-102c0,0-41.3-68.3-128.6-35.4C112.2,85.1,135,163.4,135,163.4l10.8,31.2c-23.5,5.8-21.3,42.1,3.7,44.4
											c2.7,0.2,4.6,0.1,4.6,0.1c-8.2,38.6,50.3,78.2,50.3,78.2c0.1,0.5,0.1,0.9,0.2,1.3c4,27.9-11.1,55.6-36.7,67.4
											c-25.8,11.9-49.3,28.1-62.3,37.7c-7.8,5.7-14.7,12.6-20,20.7c45,39.5,103.9,63.6,168.4,63.6c64.6,0,123.5-24.1,168.3-63.8
											C417.1,436.2,410.2,429.3,402.4,423.6z"/>
									</svg>
								</span>
								<span>
									<small>RUT:</small>
									{{f_rut(Auth::user()->rut)}}
								</span>
							</button>
							<div class="dropdown-menu dropdown-menu-right" aria-labelledby="profile">
								<!--<a class="dropdown-item" href="#">Perfil</a>-->
								<a class="dropdown-item" href="{{route('cambiarclave')}}">
									<span class="dropdown-item__icon">
										<i class="fas fa-key"></i>
									</span>
									Cambiar Clave
								</a>
								<a class="dropdown-item" href="/logout">
									<span class="dropdown-item__icon">
										<i class="fas fa-sign-out-alt"></i>
									</span>
									Cerrar Sesion
								</a>
							</div>
						</div>
					</div>
				</nav>
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item">
							<a href="/">Inicio</a>
						</li>
						@yield('main-navigation')
					</ol>
				</nav>
				<h1 class="wrapper__title">
					@yield('main-title')
				</h1>
			</div>
			<!-- Main -->
			<div class="wrapper__content">
				@yield('content')
			</div>
		</div>
	</div>
	<!-- JS -->
	<script src="{{ asset('js/app.js') }}"></script>
	<script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/chart.js@2.8.0"></script>
	
	@stack('scripts')
</body>

</html>
