@extends('Template.adminlte')

@section('main-title')
    {{ 'Adminisción Registros' }}
@endsection

@section('main-navigation')
    <li class="">Administracion</li>
    <li class="">Registros</li>
    <li class="active">Prioridad</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }
    </style>
@endpush()

@section('main-content')
    <div class="box" id="app">
        <div class="box-body">
            <div class="x_title">
                <div class="col-md-12 col-sm-12">
                    <span style="float:left;">
                        <button type="button" @click="abrirModal('prioridad','registrar')" class="btn btn-success">
                            <i class="icon-plus"></i>&nbsp;Crear Prioridad
                        </button>
                    </span>
                    <span style="float:right;">
                        <button class="btn btn-primary" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>
                    </span>
                </div>
            </div>

            <div class="x_content">
                <div class="col-md-12 col-sm-12 mt-3">
                    <!-- Tabla -->
                    <div class="ml-1 mr-1 table-responsive">
                        <table class="table table-bordered table-striped table-sm">
                            <thead>
                                <th colspan="12" class="bg-primary">
                                    <h6 class="text-center">
                                        Listado de Prioridades
                                    </h6>
                                </th>
                            </thead>
                            <thead>
                                <th style="min-width:50px; text-align:center;"> # </th>
                                <th style="min-width:100px; text-align:center;">Opciones</th>
                                <th style="min-width:200px; text-align:center;">Descripción</th>
                                <th style="min-width:200px; text-align:center;">Tiempo de Atención</th>
                                <th style="min-width:200px; text-align:center;">Estado</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            @{{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                                <button type="button" @click="abrirModal('prioridad', 'actualizar', datos)"
                                                        class="btn btn-primary btn-sm"
                                                        title="Actualizar Prioridad">
                                                            <i class="fas fa-pencil-alt" style="color:white"></i>
                                                </button>
                                                <button type="button" @click="abrirModal('prioridad', 'inhabilitar', datos)"
                                                        class="btn btn-danger btn-sm"
                                                        title="Inhabilitar Prioridad"
                                                        v-if="datos.tp_activo == 1">
                                                            <i class="far fa-minus-square" style="color:white"></i>
                                                </button>
                                                <button type="button" @click="abrirModal('prioridad', 'habilitar', datos)"
                                                        class="btn btn-primary btn-sm"
                                                        title="Habilitar Prioridad"
                                                        v-if="datos.tp_activo == 0">
                                                            <i class="far fa-plus-square" style="color:white"></i>
                                                </button>
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_prioridad }}
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_tiempo == 1">
                                                @{{ 'Tiempo estimado de atencion ' + datos.timer_atencion + ' minutos'}}
                                            </template>
                                            <template v-else>
                                                @{{ 'SIN DEFINIR' }}
                                            </template>
                                        </td>
                                        <td style="text-align:center;">
                                            <template v-if="datos.tp_activo == 1">
                                                <span>ACTIVO</span>
                                            </template>
                                            <template v-else>
                                                 <span>INACTIVO</span>
                                            </template>
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="12">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1, 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1, 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                modal_principal             :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_mensaje              :   0,
                boton_principal             :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_mensaje              :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                arr_index                   :   [],
                nr_prioridad                :   0,
                nm_prioridad                :   '',
                tp_activo                   :   1,
                //-------------------------------------
                //-------------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                cargarDatos()
                {
                    let me      =   this;
                    me.cargarIndex();
                },
                //-------------------------------------------------------------------------------------------
                cargarIndex()
                {
                    let me      =   this;
                    var ruta    =   '/administrador/prioridad/inicio';

                    axios.get(ruta, {
                    }).then(function (response)
                    {
                        console.log(response);

                        var respuesta   =   response.data;
                        me.arr_index    =   respuesta.info.data;
                        me.pagination   =   respuesta.pagination;
                        me.rows         =   respuesta.info.data;
                    }).catch(function (error)
                    {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, datos = [])
                {

                },
                //-------------------------------------------------------------------------------------------
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
              let me = this;
              me.cargarDatos();
            }
        });
    </script>
@endsection()


