@extends('Template.adminlte')

@section('main-title')
    {{ 'Revisar Solicitudes' }}
@endsection

@section('main-navigation')
    <li class="">Ejecutivo</li>
    <li class="active">Revisar</li>
@endsection

@push('styles')
    <style>
        .chart-container {
            height: 600px;
        }

        @media screen and (min-width: 1200px) {
            .chart-container {
              height: 800px;
            }
        }

        .mt-5 {
            margin-top: 2rem;
        }

        .div-error{
            display: flex;
            justify-content: center;
        }

        .text-error{
            color: red !important;
            font-weight: bold;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input { 
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>
@endpush()

@section('main-content')
    <div class="box" id="app">
        <div class="box-body">
            <div class="x_title">
                <div class="col-md-12 col-sm-12">
                    <div class="text-right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>
                </div>
            </div>

            <div class="x_content">
                <div class="col-md-12 col-sm-12 mt-3">
                    <!-- Filtro -->
                    <div class="col-md-12 col-sm-12">
                        <div class="collapse" id="filtrar_datos">
                            <div class="card">
                                <div class="card-header bg--primary">
                                    <div class="col-md-12 col-sm-12 text-center">
                                        <h5>Filtro de busqueda</h5>
                                    </div>
                                </div>
                                <div class="card-body">

                                    <div class="row ml-2 mr-2">
                                        <div class="col-md-12 col-sm-12"> </div>
                                        <!-- Tipo -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Tipo Solicitud :
                                                </label>
                                                <multiselect
                                                    :show-labels="false" 
                                                    :searchable="true" 
                                                    v-model="fl_tipo" 
                                                    :options="arr_tipos" 
                                                    :multiple="false" 
                                                    :showNoOptions="false" 
                                                    placeholder="Tipo Solicitud" 
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Prioridad -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Prioridad :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_prioridad"
                                                    :options="arr_prioridad"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Prioridad"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- N° Ticket -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    N° Ticket :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_ticket"
                                                    :options="arr_ticket"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="N° Ticket"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Unidad Vecinal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Unidad Vecinal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_unidadvecinal"
                                                    :options="arr_unidadvecinal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Unidad Vecinal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Dirección Municipal -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Dirección Municipal :
                                                </label>
                                                <multiselect 
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_direccion"
                                                    :options="arr_dir_municipal"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Dirección Municipal"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>

                                        <!-- Persona -->
                                        <div class="col-md-4 col-sm-6">
                                            <div class="form-group">
                                                <label class="form-control-label" for="text-input">
                                                    Persona :
                                                </label>
                                                <multiselect
                                                    :show-labels="false"
                                                    :searchable="true"
                                                    v-model="fl_persona"
                                                    :options="arr_persona"
                                                    :multiple="false"
                                                    :showNoOptions=false
                                                    placeholder="Persona"
                                                    label="label" track-by="label">
                                                        <span slot="noResult">No se han encontrado resultados</span>
                                                </multiselect>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div style="float: right;">
                                        <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                            <i class="fas fa-undo"></i> Quitar Filtros
                                        </button>&nbsp;
                                        <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                            Filtrar Búsqueda
                                        </button>

                                        <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                            Cerrar Filtro
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 mt-2 mb-4">
                        <div class="fom-group">
                            <label >Estados :</label>
                            <select @change="cargarDatos()"  v-model="fl_mostrar" class="form-control estados">
                                <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                            </select>
                        </div>
                    </div>

                    <!-- Tabla -->
                    <div class="ml-1 mr-1  table-responsive">
                        <table class="table table-bordered table-striped table-sm">
                            <thead class="bg--primary">
                                <th colspan="12" class="bg-indigo">
                                    <h6 class="text-center">
                                        Listado de Solicitudes
                                    </h6>
                                </th>
                            </thead>
                            <thead>
                                <th style="min-width:50px; text-align:center;"> # </th>
                                <th style="min-width:100px; text-align:center;">Opciones</th>
                                <th style="min-width:100px; text-align:center;">Ticket</th>
                                <th style="min-width:200px; text-align:center;">Fecha Ingreso</th>
                                <th style="min-width:200px; text-align:center;">Tipo Solicitud</th>
                                <th style="min-width:200px; text-align:center;">Dirección</th>
                                <th style="min-width:200px; text-align:center;">Prioridad</th>
                                <th style="min-width:200px; text-align:center;">Solicitante</th>
                                <th style="min-width:200px; text-align:center;">Ubicacion</th>                              
                                <th style="min-width:200px; text-align:center;">Tiempo Tramitado</th>
                                <th style="min-width:200px; text-align:center;">Estado Solicitud</th>
                            </thead>
                            <tbody>
                                <template v-if="arr_index.length">
                                    <tr v-for="(datos, index) in arr_index" :key="datos.id">
                                        <td style="text-align:center;">
                                            @{{ (index + 1) }}
                                        </td>
                                        <td style="text-align:center;">
                                            <button class="btn btn-sm btn-secondary" 
                                                :class="{'btn-success':datos.id_estado == 12,
                                                         'btn-danger':datos.id_estado == 13,
                                                         'btn-warning':(datos.esta_asignado == 1 && datos.debe_responder == 1 && (datos.id_estado != 12 && datos.id_estado != 13)) || 
                                                            (datos.isDirector == 1 && datos.solicitud_gestionada == 1 && datos.respuestas_faltantes == 0 && (datos.id_estado < 12)), 
                                                         'btn-info':datos.esta_asignado == 1 && datos.solicitud_gestionada == 0 && datos.gestor_solicitud == 1 && 
                                                                    (datos.id_estado != 12 && datos.id_estado != 13)}" 
                                            @click="abrirModal('solicitud', 'informacion', datos)">
                                                <i class="fas fa-search"></i>
                                            </button>
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nr_ticket }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.fc_ingreso | formatDate }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.tipo.nm_tipo }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_ubicacion }}
                                        </td>
                                        <td style="text-align:center; color: black;" :style="{'background-color':datos.prioridad.color_prioridad}">
                                            @{{ datos.prioridad.nm_prioridad }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.vecino.nm_vecino + ' ' + datos.vecino.ap_paterno }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_ubicacion }}
                                        </td>                                      
                                        <td style="text-align:center;">
                                            @{{ datos.tiempo_tramitado }}
                                        </td>
                                        <td style="text-align:center;">
                                            @{{ datos.nm_estado }}
                                        </td>
                                    </tr>
                                </template>
                                <template v-else>
                                    <tr>
                                        <td colspan="12">
                                            <h5 class="text-center">
                                                No hay datos para listar
                                            </h5>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                    <!-- Paginacion -->
                    <div class="col-md-12 col-sm-12">
                        <nav>
                            <ul class="pagination">
                                <li class="page-item" v-if="pagination.current_page > 1">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                </li>
                                <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                </li>
                                <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                    <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <!-- - - - - - - - - - - - - - - - - - - - -  Inicio de Modal - - - - - - - - - - - - - - - - - - - - -->
            <!-- Modal Principal -->
            <div id="modal_principal" class="modal scroll_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <!-- Inicio - Informacion Solicitud -->
                <div class="modal-dialog modal-xl" role="document" >
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">
                                <strong class="text-center">@{{ titulo_principal }}</strong>
                            </h5>
                            <button type="button" @click="cerrarModal('informacion');" class="close btn_activo" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body lg_modal_body">
                            <ul class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                <li class="nav-item active">
                                    <a class="nav-link active" id="info_solicitud-tab" data-toggle="tab" href="#info_solicitud" role="tab" 
                                        aria-controls="info_solicitud" aria-selected="false">
                                        <i class="far fa-list-alt"></i> Información Solicitud
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="hito_solicitud-tab" data-toggle="tab" href="#hito_solicitud" role="tab" 
                                        aria-controls="hito_solicitud" aria-selected="false" v-if="tp_municipal == 1">
                                        <i class="far fa-list-alt"></i>
                                        Historial Solicitud
                                    </a>
                                </li>
                                <div class="text-right mb-1">
                                    <button class="btn btn--primary btn_activo" @click="cargarHistorial(id_consulta)">
                                        <i class="fas fa-sync"></i> Actualizar
                                    </button>
                                </div>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane active" id="info_solicitud" role="tabpanel">
                                    <div class="row-flow">
                                        <!-- Datos usuarios -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Datos Vecino</h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Rut Vecino -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Rut Vecino</label>
                                                            <input disabled="true" @change="getVecino()" type="text" class="form-control tp_bloquear" v-model="rut_vecino" >
                                                            <small v-if="validationErrors.rut_vecino" v-text="validationErrors.rut_vecino[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Nombre -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Nombre</label>
                                                            <input type="text" maxlength="50" class="form-control tp_bloquear" v-model="nm_vecino" >
                                                            <small v-if="validationErrors.nm_vecino" v-text="validationErrors.nm_vecino[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Ap Paterno -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Apellido Paterno</label>
                                                            <input type="text" maxlength="50" class="form-control tp_bloquear" v-model="ap_paterno" >
                                                            <small v-if="validationErrors.ap_paterno" v-text="validationErrors.ap_paterno[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Ap Materno -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Apellido Materno</label>
                                                            <input type="text" maxlength="50" class="form-control tp_bloquear" v-model="ap_materno" >
                                                            <small v-if="validationErrors.ap_materno" v-text="validationErrors.ap_materno[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Telefono -->                                                    
                                                    <div class="col-md-3" >
                                                        <div class="form-group">
                                                            <label>Telefono</label>
                                                            <div class=" input-group mb-3">
                                                              <div class="input-group-prepend">
                                                                
                                                                <div class="input-group-text">
                                                                 <select v-model="pre_fijo" class="tp_bloquear">
                                                                     <option value="+569">+569</option>
                                                                     <option value="+562">+562</option>
                                                                 </select>
                                                                </div>
                                                              </div>
                                                              <input  v-model="nr_telefono" type="text"  maxlength="8" type="text" class="form-control tp_bloquear">
                                                               <small v-if="validationErrors.nr_telefono" v-text="validationErrors.nr_telefono[0]"></small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Mail -->
                                                    <div class="col-md-3 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Mail</label>
                                                            <input type="text" maxlength="50" class="form-control tp_bloquear" v-model="mail_vecino">
                                                            <small v-if="validationErrors.nm_mail" v-text="validationErrors.nm_mail[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Direccion Vecino -->
                                                    <div class="col-md-4 ">
                                                        <div class="form-group">
                                                            <label>Dirección del Vecino</label>
                                                            <multiselect 
                                                                :disabled="true"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="arr_ubicacion_vecino"
                                                                :options="arr_calles_vecino"
                                                                :multiple="false"
                                                                :showNoOptions =false
                                                                placeholder="Ingresar Ubicacion"
                                                                @search-change="indexDireccionesVecino"
                                                                label="label" track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.nm_direccion_vecino" v-text="validationErrors.nm_direccion_vecino[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Clasificacion de ubicacion vecino -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Casa/Depto/Oficina</label>
                                                            <select disabled="true" v-model="tp_direccion" class="form-control tp_bloquear">
                                                                <option value="1">Casa</option>
                                                                <option value="2">Depto</option>
                                                                <option value="3">Oficina</option>
                                                            </select>
                                                            <small v-if="validationErrors.nm_mail" v-text="validationErrors.nm_mail[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Aclaratoria -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Aclaratoria</label>
                                                            <input type="text" maxlength="50" class="form-control tp_bloquear" v-model="str_aclaratoria">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Datos Solicitud -->
                                        <div class="card mt-4">
                                            <div class="card-header bg--primary" style="color:white">
                                                <h4 class="text-center">Datos Solicitud  </h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <!-- Contexto Municipal -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Contexto Municipal :</label>
                                                            <select @change="changeContexto()" class="form-control tp_bloquear" v-model="tp_municipal">
                                                                <option value="1">SI</option>
                                                                <option value="0">NO</option>
                                                            </select>
                                                            <small v-if="validationErrors.tp_municipal" v-text="validationErrors.tp_municipal[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Tipo Solicitud -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label>Tipo Solicitud :</label>
                                                            <multiselect 
                                                                :disabled="true"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_tipo"
                                                                :options="arr_tipos"
                                                                :multiple="false"
                                                                :showNoOptions ="false" 
                                                                @select="asyncSugerencia" 
                                                                placeholder="Seleccionar Tipo de Solicitud"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.nr_tipo" v-text="validationErrors.nr_tipo[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- tipo aclaracion direccion -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Frente/Altura</label>
                                                            <select disabled="true" class="form-control tp_bloquear" v-model="nr_tp_direccion_solicitud">
                                                               <option value="1">Frente</option>
                                                               <option value="3">Altura</option>
                                                            </select>
                                                            <small v-if="validationErrors.nr_tp_direccion_solicitud" v-text="validationErrors.nr_tp_direccion_solicitud[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Ubicacion problema -->
                                                    <div class="col-md-4" v-if="nr_tp_direccion_solicitud == 1 || nr_tp_direccion_solicitud == 3">
                                                        <div class="form-group">
                                                            <label>Ubicación Problema :</label>
                                                            <multiselect 
                                                                :disabled="true" 
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="arr_direccion_solicitud"
                                                                :options="arr_calles_solicitud"
                                                                :multiple="false"
                                                                :showNoOptions =false
                                                                placeholder="Seleccionar Ubicación"
                                                                label="label" 
                                                                @search-change="indexDireccionesSolicitud"
                                                                track-by="label">
                                                                    <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.arr_direccion_solicitud" v-text="validationErrors.arr_direccion_solicitud[0]"></small>

                                                        </div>
                                                    </div>
                                                    <!-- Calles -->
                                                    <div class="col-md-6" v-else>
                                                        <label for="">Ingresar Calles</label>
                                                        <div class="input-group">
                                                          <div class="input-group-prepend">
                                                            <span class="input-group-text">Intersecciones</span>
                                                          </div>
                                                            <select :disabled="true" v-model="dir_1" class="form-control buscador">
                                                                <option v-text="calle.label" :value="calle.label" v-for="calle in arr_data_default.calles"></option>
                                                             
                                                            </select>
                                                            <select :disabled="true" v-model="dir_2" class="form-control buscador">
                                                                <option v-text="calle.label" :value="calle.label" v-for="calle in arr_data_default.calles"></option>
                                                            </select>
                                                        </div>
                                                        <small v-if="validationErrors.nm_direccion_solicitud" v-text="validationErrors.nm_direccion_solicitud[0]"></small>
                                                    </div>
                                                    <!-- Prioridad -->
                                                    <div class="col-md-2 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Prioridad</label>
                                                            <multiselect 
                                                                :disabled="true"
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_prioridad"
                                                                :options="arr_prioridad"
                                                                :multiple="false"
                                                                :showNoOptions ="false" 
                                                                @select="asyncSugerencia" 
                                                                placeholder="Seleccionar Prioridad"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.nr_prioridad" v-text="validationErrors.nr_prioridad[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Direccion Municipal -->
                                                    <div class="col-md-4 col-sm-6">
                                                        <div class="form-group">
                                                            <label >Dirección Municipal :</label>
                                                            <multiselect 
                                                                :disabled="true" 
                                                                :show-labels="false"
                                                                :searchable="true"
                                                                v-model="nr_dir_municipal"
                                                                :options="arr_dir_municipal"
                                                                :multiple="false"
                                                                :showNoOptions ="false" 
                                                                @select="asyncSugerencia" 
                                                                placeholder="Seleccionar Dirección Municipal"
                                                                label="label"                                                                 
                                                                track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                            </multiselect>
                                                            <small v-if="validationErrors.nr_dir_municipal" v-text="validationErrors.nr_dir_municipal[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Descripcion Solicitud -->
                                                    <div class="col-md-8">
                                                        <div class="form-group">
                                                            <label>Descripción Solicitud :</label>
                                                            <textarea maxlength="2000" rows="2" v-model="str_observacion" class="form-control tp_bloquear"></textarea>
                                                            <small class="form-text text-muted" id="str_observacion"  v-if="str_observacion" 
                                                                v-text="'Disponible '+(2000-str_observacion.trim().length)+' caracteres'"></small>
                                                            <small v-if="validationErrors.str_observacion" v-text="validationErrors.str_observacion[0]"></small>
                                                        </div>
                                                    </div>
                                                    <!-- Tabla de Archivos Adjuntos -->
                                                    <div class="table-responsive">
                                                        <table  class="table table-bordered table-striped table-sm" style="width: 100%">
                                                            <thead>
                                                                <tr class="bg--primary">
                                                                    <th class="text-center" colspan="4">Documentos Adjuntos 
                                                                        <button @click="abrirModal('archivo','anexar')" class="btn btn-primary btn-sm"> 
                                                                            <i class="fas fa-plus"></i>
                                                                        </button>
                                                                    </th>
                                                                </tr>
                                                                <tr v-if="arr_archivo.length || ( solicitud_actual.archivos && solicitud_actual.archivos.length)">
                                                                    <th>#</th>
                                                                    <th>Nombre</th>
                                                                    <th>Descripción</th>
                                                                    <th>Opción</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <template v-if="arr_archivo.length">
                                                                    <tr>
                                                                        <th class="text-center bg--primary" colspan="4" style="color:white">Archivos por Cargar</th>
                                                                        
                                                                    </tr>
                                                                    <tr v-if="arr_archivo.length" v-for="(archivo, index) in arr_archivo" :key="index">
                                                                        <td class="text-center">@{{ (index+1) }}</td>
                                                                        <td>@{{ archivo.nm_archivo }}</td>
                                                                        <td>@{{ archivo.str_observacion }}</td>
                                                                        <td class="text-center">
                                                                            <button type="button" class="btn btn-sm btn-danger" title="Quitar Documento" @click="quitarAdjunto('archivo', index);">
                                                                                <i class="fas fa-times-circle"></i> Quitar
                                                                            </button>
                                                                        </td>
                                                                    </tr>
                                                                </template>
                                                                <template v-if="solicitud_actual.archivos && solicitud_actual.archivos.length">
                                                                    <tr>
                                                                        <th class="text-center bg-success" colspan="4" style="color:white">Archivos Cargados</th>
                                                                        
                                                                    </tr>
                                                                    <tr v-for="archivo in solicitud_actual.archivos" >
                                                                        <td>
                                                                            <a target=_blank :href="'/files/get/?ruta='+archivo.str_archivo">@{{ archivo.nm_archivo }}</a>
                                                                        </td>
                                                                        <td>@{{ archivo.str_observacion }}</td>
                                                                        <td class="text-center">
                                                                            <button disabled @click="deleteFiles(archivo.str_archivo,archivo.nm_archivo)" type="button" class="btn btn-sm btn-danger" title="Quitar Documento">
                                                                                <i class="fas fa-times-circle"></i> Eliminar
                                                                            </button>
                                                                        </td>
                                                                    </tr>
                                                                </template>
                                                               
                                                                <template v-if="!solicitud_actual.archivos && !arr_archivo.length">
                                                                    <td colspan="4">
                                                                        <div class="empty" empty-text="No hay archivos adjuntos para listar"></div>
                                                                    </td>
                                                                </template>                                                
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane" id="hito_solicitud" role="tabpanel">
                                    <div class="form-group mt-3">
                                            <ul style="list-style-type: none;" class="timeline">
                                                <li v-for="(hito, index) in arr_historial" :key="hito.id">
                                                    <div class="row">
                                                        <div class="form-group col-md-12 col-sm-12" style="padding-left:30px;">
                                                            <!-- Titulo Hito -->
                                                            <div class="row" style="padding-left: 20px;">
                                                                <div class="col-md-10 col-sm-9">
                                                                    <a href="#" vi>
                                                                        <template v-if="hito.id_estado == 1">
                                                                            @{{ (index+1) + '.- ' + 'Funcionario Municipal - ' + hito.nm_autor }}
                                                                        </template>
                                                                        <template v-if="hito.id_estado == 2 || hito.id_estado == 3 || hito.id_estado == 4">
                                                                            @{{ (index+1) + '.- ' + 'Jefe Macro Zona' }}
                                                                        </template>
                                                                        <template v-if="hito.id_estado == 5 || hito.id_estado == 6 || hito.id_estado == 7">
                                                                            @{{ (index+1) + '.- ' + 'Jefe Territorial' }}
                                                                        </template>
                                                                        <template v-if="hito.id_estado == 8 || hito.id_estado == 9 || hito.id_estado == 10 || hito.id_estado == 11">
                                                                            @{{ (index+1) + '.- ' + hito.unidad_destino[0]['nm_direccion'] }}
                                                                        </template>
                                                                        <template v-if="hito.id_estado == 12 || hito.id_estado == 13">
                                                                            @{{ (index+1) + '.- ' + 'Unidad Territorial - ' }}
                                                                        </template>
                                                                    </a>
                                                                </div>
                                                                <div class="col-md-2 col-sm-3">
                                                                    <a href="#"> 
                                                                        @{{'Duración ' + hito.fc_diferencia + ' días'}}
                                                                    </a>
                                                                </div>
                                                            </div>

                                                            <!-- Detalle Hito -->
                                                            <div class="col-md-12 col-sm-12">
                                                                <p style="margin-bottom: 0px">
                                                                    <strong>Fecha Inicio :</strong><span v-if="hito.fc_inicio">@{{ hito.fc_inicio }}</span><br>
                                                                    <strong>Fecha Término :</strong><span v-if="hito.fc_termino">@{{ hito.fc_termino }}</span><br>
                                                                    <span v-if="hito.str_observacion">
                                                                        <strong>Observación :</strong> @{{ hito.str_observacion.trim() }} <br>
                                                                    </span>
                                                                    <template v-if="hito.visador.length">
                                                                        <div v-for="(visador, indice) in hito.visador" :key="indice">
                                                                            <span v-if="visador.nm_visador">
                                                                                <strong>Visador : </strong> @{{ visador.nm_visador }} <br>
                                                                            </span>
                                                                            <span v-if="visador.str_observacion">
                                                                                <strong>Observación Visado :</strong> @{{ visador.str_observacion }} <br>
                                                                            </span>
                                                                        </div>
                                                                    </template>
                                                                    <template v-if="hito.id_estado == 9">
                                                                        <span v-if="hito.unidad_destino.length">
                                                                            <strong>Unidad Destino : </strong> @{{ hito.unidad_destino[0]['nm_direccion'] }} <br>
                                                                        </span>                                                                        
                                                                    </template>
                                                                </p>                                                                
                                                            </div>

                                                            <!-- Menu de acciones y Observaciones -->
                                                            <div v-if="(hito.id_estado == 8 || hito.id_estado == 9 || hito.id_estado == 10)">
                                                                <div class="row col-md-12 col-sm-12">
                                                                    
                                                                    <button type="button" v-if="hito.respuestaRealizada != 1 && 
                                                                        (hito.id_estado_solicitud != 12 && hito.id_estado_solicitud != 13)"
                                                                        class=" ml-2 mt-2 btn btn-sm btn-secondary dropdown-toggle btn_activo" 
                                                                            :class="{'btn-warning':(hito.id_estado == 8 && hito.debe_responder == 1) || 
                                                                                    (hito.solicitud_gestionada == 1 && hito.respuestasFaltantes == 0 && hito.id_estado_solicitud < 12),
                                                                                 'btn-info':hito.solicitud_gestionada == 0}" 
                                                                            data-toggle="dropdown" aria-haspopup="true" 
                                                                            aria-expanded="false">
                                                                                Acciones
                                                                    </button>

                                                                    <button  class="btn btn-primary ml-2 mt-2 btn_activo" id="btn_ver_observaciones"
                                                                        @click="mostrarObservaciones()">
                                                                            <i class="fas fa-comments"></i> Ver Observaciones
                                                                    </button>

                                                                    <!-- Acciones -->
                                                                    <div class="dropdown-menu ml-1">
                                                                        <!-- Responder y Finalizar-->
                                                                        <a class="dropdown-item" href="#" v-if="(hito.isDirector == 1 && hito.respuestasFaltantes == 0 && hito.id_estado_solicitud < 12) 
                                                                            || (hito.esta_asignado == 1 && hito.debe_responder == 1 && hito.respuestasFaltantes == 1)"
                                                                            @click="abrirModal('historial','finalizar',hito)">
                                                                                <i class="fas fa-reply"></i> 
                                                                                    Responder y Finalizar
                                                                        </a>

                                                                        <a class="dropdown-item" href="#" v-if="hito.esta_asignado == 1 && hito.debe_responder == 1 && hito.isDirector != 1"
                                                                            @click="abrirModal('historial','responder',hito)">
                                                                                <i class="fas fa-reply"></i>
                                                                                    Responder
                                                                        </a>

                                                                        <a class="dropdown-item" href="#" v-if="(hito.id_estado_solicitud != 12 && hito.id_estado_solicitud != 13)"
                                                                            @click="abrirModal('historial','observacion',hito)">
                                                                                <i class="fas fa-reply"></i>
                                                                                    Observación
                                                                        </a>

                                                                        <!-- Ingresar Participantes -->
                                                                        <a class="dropdown-item" href="#" 
                                                                            v-if="hito.esta_asignado == 1 && hito.solicitud_gestionada == 0 && hito.id_accion < 11 && hito.isDirector == 1"
                                                                            @click="abrirModal('historial','asignar',hito)">
                                                                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                                                                    Asignar
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <!-- Tabla de Encargados y Observaciones -->
                                                            <template v-if="hito.encargado.length">
                                                                <!-- Tabla de encargados -->
                                                                <div class="table-responsive pr-5">
                                                                    <table class="table table-bordered table-striped table-sm mr-5 mt-2 ">
                                                                        <thead class="bg--primary">
                                                                            <tr class="bg-info">
                                                                                <th colspan="6" class="text-center">Lista de Funcionarios</th>
                                                                            </tr>
                                                                            <tr>
                                                                                <th style="min-width:100px; text-align:center;">#</th>
                                                                                <template v-if="hito.isDirector == 1">
                                                                                    <th style="min-width:100px; text-align:center;">Opción</th>
                                                                                </template>                                                                                
                                                                                <th style="min-width:100px; text-align:center;">Fecha Asignado</th>
                                                                                <th style="min-width:100px; text-align:center;">Nombre</th>
                                                                                <th style="min-width:100px; text-align:center;">Contestado</th>
                                                                                <th style="min-width:100px; text-align:center;">Fecha Contestado</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <template v-if="hito.encargado.length">
                                                                                <tr v-for="(funcionario, index) in hito.encargado" :key="funcionario.id">
                                                                                    <td class="text-center">@{{ (index + 1) }}</td>
                                                                                    <template v-if="hito.isDirector == 1">
                                                                                        <td class="text-center">
                                                                                            <button type="button" class="btn btn-sm btn-danger" title="Inhabilitar Funcionario" 
                                                                                                @click="abrirModal('historial', 'inhabilitar', funcionario)" 
                                                                                                v-if="(hito.isDirector == 1 && funcionario.tp_activo == 1 && funcionario.tp_validado == 0) && 
                                                                                                    (funcionario.tp_responsable == 1 || funcionario.tp_participante == 1) && 
                                                                                                    funcionario.is_usuario == 0">
                                                                                                    <i class="far fa-minus-square"></i>
                                                                                            </button>
                                                                                        </td>
                                                                                    </template>                                                                                        
                                                                                    <td class="text-center">@{{ funcionario.fc_asignado }}</td>
                                                                                    <td class="text-center">@{{ funcionario.nm_encargado }}</td>
                                                                                    <td class="text-center">
                                                                                        <template v-if="funcionario.tp_validado == 1">
                                                                                            <button class="btn btn-sm btn-success">
                                                                                                <i class="fas fa-check"></i>
                                                                                            </button>
                                                                                        </template>
                                                                                        <template v-else>
                                                                                            <button class="btn btn-sm btn-danger">
                                                                                                <i class="fas fa-ban"></i>
                                                                                            </button>
                                                                                        </template>
                                                                                    </td>
                                                                                    <td class="text-center">@{{ funcionario.fc_validado }}</td>
                                                                                </tr>
                                                                            </template>
                                                                            <template v-else>
                                                                                <td colspan="5">
                                                                                    <div class="empty" empty-text="No hay datos para listar"></div>
                                                                                </td>
                                                                            </template>
                                                                        </tbody>
                                                                    </table>
                                                                </div>

                                                                <!-- Listado de Observaciones -->
                                                                <div class="collapse" id="ver_observaciones">
                                                                    <div class="col-md-12 col-sm-12 mt-1" style="padding-left: 0px;margin-left: 0px;">
                                                                        <div class="col-md-12 col-sm-12" style="padding-left: 0px;margin-left: 0px;">
                                                                            <div class="bg-info text-center">
                                                                                <h5 style="color:white">Observaciones</h5>
                                                                            </div>
                                                                        </div>
                                                                        <div class="row">
                                                                            <template v-if="hito.observaciones.length">
                                                                                <ul class=" list-style-type: none col-md-12 col-sm-12 ml-3">
                                                                                    <li style="list-style-type: none" v-for="obs in hito.observaciones" :key="obs.id"
                                                                                        style="margin-bottom:5px; margin-top:5px;">
                                                                                        <div class="row">
                                                                                            <div class="timeline-arrow"></div>
                                                                                            <div class="col-md-11 col-sm-11 ml-4">
                                                                                                <a class="row" href="#" vi>
                                                                                                    <div class="col-md-6 col-sm-6">
                                                                                                        <template v-if="obs.tp_observacion == 1">
                                                                                                            @{{ 'Respuesta de Cierre - ' + obs.nm_autor  }}
                                                                                                        </template>
                                                                                                        <template v-if="obs.tp_observacion == 2">
                                                                                                            @{{ 'Respuesta - ' + obs.nm_autor  }}
                                                                                                        </template>
                                                                                                        <template v-if="obs.tp_observacion == 3">
                                                                                                            @{{ 'Observación - ' + obs.nm_autor  }}
                                                                                                        </template>
                                                                                                        <button type="button" 
                                                                                                            class="btn btn-sm btn-primary ml-2" 
                                                                                                            title="Revisar Adjuntos" 
                                                                                                            @click="abrirModal('archivo', 'revisar', obs)">
                                                                                                                <i class="fas fa-paperclip"></i>
                                                                                                        </button>
                                                                                                    </div>
                                                                                                    <div class="col-md-6 col-sm-6 text-right">
                                                                                                        <i class="far fa-calendar"></i>
                                                                                                        @{{ obs.fc_observacion }}
                                                                                                    </div>
                                                                                                </a>
                                                                                            </div>
                                                                                            <div class="row col-md-12 col-sm-12">
                                                                                                <div class="col-md-9 col-sm-9 ml-4">
                                                                                                    <p class="text-small mt-1 font-weight-light"
                                                                                                    style="margin-bottom:0px; margin-top:2px;">
                                                                                                        @{{ obs.str_observacion }}
                                                                                                    </p>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-md-11 col-sm-11 ml-3">
                                                                                                <hr class="my-2">
                                                                                            </div>
                                                                                        </div>
                                                                                    </li>
                                                                                </ul>
                                                                            </template>
                                                                            <template v-else>
                                                                                <div class="col-md-12 col-sm-12 text-center">
                                                                                    <label class="form-control-label" for="input-text">
                                                                                        No hay observaciones disponibles
                                                                                    </label>
                                                                                </div>
                                                                            </template>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </template>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn_activo" @click="cerrarModal('informacion');">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Secundario -->
            <div id="modal_secundario" class="modal scroll_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <!-- Registrar Observacion -->
                <div class="modal-dialog modal-xl" role="document" v-if="accion_secundario == 1">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="titulo_secundario"></h5>
                            <button type="button" @click="cerrarModal('secundario');" class="close btn_activo" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="col-md-12 col-sm-12 ml-2 mr-2">
                                <div class="form-group">
                                    <label>Ingresar Respuesta :</label>
                                    <textarea maxlength="2000" rows="5" v-model="str_observacion" class="form-control"></textarea>
                                    <small id="cant_caracteres" class="form-text text-muted" 
                                        v-text="'Disponible '+(2000-str_observacion.trim().length)+' caracteres'" v-if="str_observacion"></small>
                                    <div v-for="error in arr_error" class="text-error text-center" :key="error"  v-text="error">
                                    </div>
                                </div>
                            </div>

                            <div class="content__buttons">
                                <div class="col-md-6 col-md-12">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                            <div class="text-left">
                                                <button @click="abrirModal('archivo','anexar')" type="button" class="btn btn-primary btn_activo">
                                                    <i class="fas fa-upload"></i> Subir Documento
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-sm-6" v-if="tp_observacion == 1">
                                            <div class="text-right">
                                                <div class="form-group">
                                                    <label class="text-small">Informar a Vecino</label>
                                                    <label class="switch" style="align:right">
                                                        <input type="checkbox" id="tp_informar" v-model="tp_informar">
                                                        <span class="slider round"></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped table-sm">
                                            <thead>
                                                <tr class="bg--primary">
                                                    <th class="text-center" colspan="4">Documentos Adjuntos</th>
                                                </tr>
                                                <tr>
                                                    <th class="text-center" width="50px">#</th>
                                                    <th class="text-center" width="150px">Nombre</th>
                                                    <th class="text-center" width="400px">Descripción</th>
                                                    <th class="text-center" width="50px">Opción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <template v-if="arr_archivo.length">
                                                    <tr v-for="(archivo, index) in arr_archivo" :key="index">
                                                        <td class="text-center">@{{ (index+1) }}</td>
                                                        <td>@{{ archivo.file.name }}</td>
                                                        <td>@{{ archivo.descripcion }}</td>
                                                        <td class="text-center">
                                                            <button type="button" class="btn btn-sm btn-danger" title="Quitar Documento" @click="quitarAdjunto('archivo', index);">
                                                                <i class="fas fa-times-circle"></i> Quitar
                                                            </button>
                                                        </td>
                                                    </tr>
                                                </template>
                                                <template v-else>
                                                    <td colspan="4">
                                                        <div class="empty" empty-text="No hay archivos adjuntos para listar"></div>
                                                    </td>
                                                </template>                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light btn_activo" @click="cerrarModal('secundario');">Cerrar</button>
                            <template v-if="boton_secundario == 1">
                                <button type="button" class="btn btn-primary btn_activo" @click="ensamblarDatos('observacion')">
                                    <i class="fas fa-edit"></i> Guardar
                                </button>
                            </template>
                        </div>
                    </div>
                </div>
                
                <!-- Inicio - Registrar Personal -->
                <div class="modal-dialog modal-xl" role="document" v-if="accion_secundario == 2">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="titulo_secundario"></h5>
                            <button type="button" class="close btn_activo" @click="cerrarModal('secundario');" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body" id="ingresoModal">
                            <div class="col-md-12 col-sm-12 ml-2 mr-2">
                                <div class="form-group">
                                    <label>Funcionario</label>
                                        <multiselect 
                                        :show-labels="false" 
                                        :searchable="true" 
                                        v-model="nr_subordinados"
                                        :options="arr_subordinados"
                                        :multiple="true" 
                                        :showNoOptions =false
                                        placeholder="Seleccionar Funcionario"                                                             
                                        label="label" track-by="label"
                                    >
                                        <span slot="noResult">No se han encontrado resultados</span>
                                    </multiselect>
                                </div>

                                <div class="form-group mt-3">
                                    <textarea maxlength="2000" rows="3" v-model="str_obs_asignar" class="form-control"
                                        placeholder="Ingresar observación"></textarea>
                                    <small id="cant_caracteres" class="form-text text-muted" v-if="str_obs_asignar"
                                        v-text="'Disponible '+(2000-str_obs_asignar.trim().length)+' caracteres'">
                                    </small>
                                     <div v-for="error in arr_error" class="text-error text-center" :key="error"  v-text="error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light btn_activo" @click="cerrarModal('secundario');">Cerrar</button>
                            <template v-if="boton_secundario == 2">
                                <button v-if="tp_btn == 0" type="button" class="btn btn-primary btn_activo" :disabled='(nr_subordinados.length == 0)' @click="ensamblarDatos('asignar')">
                                    <i class="fas fa-edit"></i> Asignar Personal 
                                </button>

                                <button v-else type="button" class="btn btn-success ">Asignando Personal <i class="fas fa-spin fa-spinner"></i></button>
                            </template>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Validacion -->
            <div id="modal_validacion" class="modal scroll_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <!-- Validacion -->
                <div class="modal-dialog modal-xl" role="document" v-if="accion_validacion == 1">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title">
                                <strong class="text-center" style="color:white">@{{ titulo_validacion }}</strong>
                            </h5>
                            <button type="button"  @click="cerrarModal('validacion');" class="close btn_activo" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                        <div class="modal-body">
                            <div class="row-flow">
                                <h5>
                                   <span>@{{ mensaje_validacion }}</span>
                                </h5>                                   
                            </div>
                        </div>

                        <div class="modal-footer">                            
                            <template v-if="boton_validacion == 1">
                                <button type="button" id="btnVisar" class="btn btn-primary btn_activo" @click="ensamblarDatos('inhabilitar_funcionario')">
                                    <i class="fas fa-thumbs-up"></i> Liberar
                                </button>                                
                            </template>
                            <button type="button" class="btn btn-secondary btn_activo" @click="cerrarModal('validacion');">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Adjunto -->
            <div id="modal_adjunto" class="modal scroll_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <!-- Aduntar Archivos -->
                <div class="modal-dialog modal-lg" role="document" v-if="accion_adjunto == 1">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="titulo_adjunto"></h5>
                            <button type="button" class="close btn_activo" @click="cerrarModal('archivo')" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <input accept=".jpeg,.jpg,.png,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.dwg,.dgn,.rar,.zip"
                                    type="file" id="file_adjunto" @change="validarAdjunto('documento','')">
                            </div>
                            <div class="form-group">
                                <textarea maxlength="200" rows="3" v-model="file_observacion" class="form-control" placeholder="Descripción del archivo"></textarea>
                                <small id="cant_caracteres" class="form-text text-muted" v-text="'Disponible '+(200-file_observacion.trim().length)+' caracteres'" v-if="file_observacion"></small>
                            </div>
                            <div v-show="tp_error" class="alert alert-danger mb-2" role="alert">
                                <div class="text-center">
                                    <div v-for="error in arr_error" :key="error" v-text="error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button @click="cerrarModal('archivo')" type="button" class="btn btn-light btn_activo">Cerrar</button>
                            <button type="button" class="btn btn-primary btn_activo" @click="validarAdjunto(tp_adjunto, 'save')">Subir</button>
                        </div>
                    </div>
                </div>

                <!-- Revisar Archivos -->
                <div class="modal-dialog modal-lg" role="document" v-if="accion_adjunto == 2">
                    <div class="modal-content">
                        <div class="modal-header bg--primary">
                            <h5 class="modal-title" v-text="titulo_adjunto"></h5>
                            <button type="button" class="close btn_activo" @click="cerrarModal('archivo')" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-sm">
                                    <thead>
                                        <tr class="bg--primary">
                                            <th colspan="4" class="text-center">Archivos Adjuntos</th>
                                        </tr>
                                        <tr>
                                            <th style="min-width:50px; text-align:center;">#</th>
                                            <th style="min-width:150px; text-align:center;">Nombre</th>
                                            <th style="min-width:300px; text-align:center;">Descripción</th>
                                            <th style="min-width:50px; text-align:center;">Archivo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <template v-if="arr_archivo.length">
                                            <tr v-for="(adjunto, index) in arr_archivo" :key="adjunto.id">
                                                <td class="text-center">@{{ (index+1) }}</td>
                                                <td class="text-center">@{{ adjunto.nm_archivo }}</td>
                                                <td class="text-left">@{{ adjunto.str_observacion }}</td>
                                                <td class="text-center">
                                                    <a :href="'/files/get/?ruta='+adjunto.str_archivo" class="btn btn--primary btn-sm" title="Archivo Adjunto" v-if="adjunto.str_archivo">
                                                        <template v-if="adjunto.ext_archivo == 'pdf'">
                                                            <i class="far fa-file-pdf"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'doc' || adjunto.ext_archivo == 'docx'">
                                                            <i class="far fa-file-word"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'ppt' || adjunto.ext_archivo == 'pptx'">
                                                            <i class="far fa-file-powerpoint"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'xls' || adjunto.ext_archivo == 'xlsx'">
                                                            <i class="far fa-file-excel"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'rar' || adjunto.ext_archivo == 'zip'">
                                                            <i class="far fa-file-archive"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'jpeg' || adjunto.ext_archivo == 'jpg' || adjunto.ext_archivo == 'png'">
                                                            <i class="far fa-file-image"></i>
                                                        </template>
                                                        <template v-if="adjunto.ext_archivo == 'dwg' || adjunto.ext_archivo == 'dgn'">
                                                            <i class="far fa-file-code"></i>
                                                        </template>
                                                    </a>
                                                </td>
                                            </tr>
                                        </template>
                                        <template v-else>
                                            <td colspan="4">
                                                <div class="empty" empty-text="No hay archivos para mostrar"></div>
                                            </td>
                                        </template>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button @click="cerrarModal('archivo')" type="button" class="btn btn-light btn_activo">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>            
        <!-- - - - - - - - - - - - - - - - - - - - - Termino de Modal - - - - - - - - - - - - - - - - - - - - -->        
    </div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //---------------------------------
                rut_vecino                  :   '',
                nm_vecino                   :   '',
                ap_paterno                  :   '',
                ap_materno                  :   '',
                str_vecino                  :   '',
                nm_direccion                :   '',
                nr_direccion                :   0,
                pre_fijo                    :   '+569',
                nr_telefono                 :   '',
                mail_vecino                 :   '',
                nr_afectado                 :   1,
                tp_vecino                   :   0,                
                arr_ubicacion_vecino        :   [],                
                tp_direccion                :   1,
                str_aclaratoria             :   '',
                //---------------------------------
                modal_principal             :   0,
                modal_secundario            :   0,
                modal_adjunto               :   0,
                modal_validacion            :   0,
                modal_mensaje               :   0,
                accion_principal            :   0,
                accion_secundario           :   0,
                accion_adjunto              :   0,
                accion_validacion           :   0,
                accion_mensaje              :   0,
                boton_principal             :   0,
                boton_secundario            :   0,
                boton_adjunto               :   0,
                boton_validacion            :   0,
                boton_mensaje               :   0,
                titulo_principal            :   '',
                titulo_secundario           :   0,
                titulo_adjunto              :   '',
                titulo_validacion           :   '',
                titulo_mensaje              :   '',
                mensaje_validacion          :   '',
                tp_modal                    :   0,
                tp_municipal                :   0,
                tp_btn                      :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                tp_error                    :   0,
                arr_calles_vecino           :   [],
                arr_calles_solicitud        :   [],
                arr_data_default            :   [],
                //-------------------------------------
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                arr_archivo                 :   [],
                arr_files                   :   [],
                arr_files_obs               :   [],
                solicitud_actual            :   [],
                file_observacion            :   '',
                tp_adjunto                  :   '',
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   8,
                        'label'     :   'Asignados',
                    },
                    {
                        'value'     :   12,
                        'label'     :   'Finalizados',
                    },
                ],
                fl_mostrar                  :   8,
                //-------------------------------------
                fl_tipo                     :   [],
                fl_prioridad                :   [],
                fl_funcionario              :   [],
                fl_persona                  :   [],
                fl_direccion                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                //-------------------------------------
                arr_info                    :   [],
                //-------------------------------------
                arr_index                   :   [],
                arr_historial               :   [],
                arr_tipos                   :   [],
                arr_prioridad               :   [],
                arr_ubicacion               :   [],
                arr_carga_data              :   [],
                arr_subordinados            :   [],
                arr_dir_municipal           :   [],
                arr_ticket                  :   [],
                arr_unidadvecinal           :   [],
                arr_persona                 :   [],
                //-------------------------------------
                nr_tipo                     :   [],
                nr_prioridad                :   [],
                nr_direccion                :   [],
                nr_subordinados             :   [],
                //-------------------------------------
                tp_rechazar                 :   0,
                id_consulta                 :   0,
                nr_id_historia              :   0,
                nr_id_despacho              :   0,
                nr_id_encargado             :   0,
                nr_id_usuario               :   0,
                nr_id_dir_destino           :   0,
                nr_id_estado                :   0,
                tp_observacion              :   0,
                str_observacion             :   '',
                arr_funcionarios            :   [],
                str_obs_asignar             :   '',
                nr_tp_direccion_solicitud   :    1,
                nr_dir_municipal            :   [],
                //-------------------------------------
                dir_1                       :   0,
                dir_2                       :   0,
                arr_direccion_solicitud     :   [],
                //-------------------------------------
                validationErrors            :   [],
                nr_dir_disabled             :   0,
                nr_id_autor                 :   0,
                tp_visado                   :   0,
                //-----------------------------------
                tp_solicitud_gestionada     :   0,
                tp_informar                 :   false,
                //-----------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
                Multiselect: window.VueMultiselect.default,
                //-------------------------------------------------------------------------------------------
            },

            filters:{
                resumir: function ($texto, $limite=90, $final=' ...->')
                {
                    var largo = $texto.toString().length;
                    if(largo > $limite){
                        for (var i = 0; i < largo; i++) {
                            if($texto[i] == ' ' && i >= $limite){
                                $texto = $texto.substring(0,i);
                                $texto = $texto + $final;
                                return $texto;
                            }
                        }                    
                    }
                    return $texto;
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY')
                    }
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;

                    me.cargarDataDefault();
                    me.cargarIndex();                    
                },
                //-------------------------------------------------------------------------------------------
                asyncSugerencia(item) // Sugerir Direccion
                {
                    let me  =   this;

                    if(Object.keys(item).length > 0)
                    {
                        var tipos   = me.arr_data_default.arr_tiposs
                        var index   = tipos.map(function (nodo) { return nodo.value; }).indexOf(item.value);
                        me.nr_dir_municipal = tipos[index].id_direccion
                    }
                },
                //-------------------------------------------------------------------------------------------
                getVecino()
                {
                    let me      = this;
                    var ruta    = '/get/vecino/'+me.rut_vecino
                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           = response.data.vecino;

                        if(!respuesta)
                            return
                       
                        me.nm_vecino                    = respuesta.nm_vecino;
                        me.ap_paterno                   = respuesta.ap_paterno;
                        me.ap_materno                   = respuesta.ap_materno;
                        me.mail_vecino                  = respuesta.nm_mail;
                        me.tp_direccion                 = respuesta.tp_direccion;
                        me.str_aclaratoria              = respuesta.str_aclaratoria;
                        me.nr_telefono                  = respuesta.nr_telefono.slice(-8);
                        me.pre_fijo                     = respuesta.nr_telefono.slice(0,4);
                      
                        me.arr_ubicacion_vecino.label    =   respuesta.nm_direccion;
                        me.arr_ubicacion_vecino.value    =   respuesta.nr_direccion;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me = this;
                    //Actualiza la página actual
                    me.pagination.current_page = page;
                    //Envia la petición para visualizar la data de esa página
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                changeContexto()
                {
                    let me = this;
                    if(me.tp_municipal == 0)
                        {
                            me.nr_dir_municipal = 0;
                            me.nr_dir_disabled = 1;
                        }
                    else
                        me.nr_dir_disabled = 0;
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarIndex();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_tipo          =   [];
                    me.fl_prioridad     =   [];
                    me.fl_funcionario   =   [];
                    me.fl_persona       =   [];
                    me.fl_direccion     =   [];
                    me.fl_unidadvecinal =   [];
                    me.fl_ticket        =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getRut(data)
                {
                    var valor   =   '';

                    if (!(typeof data == "undefined") && !(data == null))
                    {
                        valor   =   data.nr_rut;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                validarAdjunto(tipo, accion)
                {
                    let me                  =   this;
                    var extension           =   '';
                    var fileSize            =    0;
                    var file_adjunto        =   '';
                    var file_value          =   '';
                    var max                 =    3;
                    var temp                =   [];
                    me.arr_error            =   [];
                    me.tp_error             =    0;

                    switch(tipo)
                    {
                        case "documento":
                        {
                            file_adjunto    =   document.querySelector("#file_adjunto");
                            file_value      =   file_adjunto.value;
                            var tipo_ext    =   ['.jpeg','.jpg','.png','.doc','.docx','.xls','.xlsx',
                                                '.ppt','.pptx','.msg','.pdf','.dwg','.dgn','.rar','.zip'];

                            if(file_value != "")
                            {
                                var fileSize  = file_adjunto.files[0].size;
                                extension = (file_value.substring(file_value.lastIndexOf("."))).toLowerCase();

                                if(fileSize > 20971520 ) 
                                    me.arr_error.push("El archivo adjunto NO debe superar los 20 MB");

                                if(!tipo_ext.includes(extension))
                                    me.arr_error.push("El archivo seleccionado No es adminido");

                                if(me.arr_archivo.length == max)
                                    me.arr_error.push("Solo se pueden adjuntar "+max+" archivos maximo");
                            }

                            if(me.arr_error.length)
                            {
                                me.descartarAdjunto();
                            }

                            if(accion == "save" && me.arr_error.length == 0 && file_value != "")
                            {
                                var archivo     =   file_adjunto.files[0];
                                me.arr_files.push(archivo);
                                me.arr_files_obs.push(me.file_observacion);
                                me.arr_archivo.push({'file':archivo, 'descripcion':me.file_observacion});
                                me.cerrarModal('archivo');
                                me.descartarAdjunto();
                            }

                            break;
                        }
                    }

                    if(me.arr_error.length) 
                    {
                        me.tp_error   =   1;
                    }

                    return me.arr_error;
                },
                //-------------------------------------------------------------------------------------------
                descartarAdjunto()
                {
                    let me              =   this;
                    var file_adjunto    =   '';

                    file_adjunto    =   document.querySelector("#file_adjunto");

                    if(file_adjunto)
                    {
                        document.querySelector("#file_adjunto").value = "";
                    }
                },
                //-------------------------------------------------------------------------------------------
                quitarAdjunto(tipo, index)
                {
                    let me          =   this;
                    me.errorModal   =   [];

                    switch(tipo)
                    {
                        case 'archivo':
                        {
                            me.arr_files.splice(index, 1);
                            me.arr_archivo.splice(index, 1);
                            me.arr_files_obs.splice(index, 1);

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                mostrarObservaciones()
                {
                    let me  =   this;

                    $("#ver_observaciones").slideToggle(500, function () {
                            // ---------------------------
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarSubordinados(nr_dir_destino)
                {
                    let me      =   this;
                    var ruta    =   '/subordinados/listado';

                    axios.post(ruta,{
                            'nr_direccion'      :   me.nr_id_dir_destino,
                            'nr_solicitud'      :   me.id_consulta,
                            'nr_despacho'       :   me.nr_id_despacho,
                    }).then(function (response) 
                    {
                        var respuesta           =   response.data;
                        me.arr_subordinados     =   respuesta.subordinados;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDataDefault()
                {
                    let me      =   this;
                    var ruta    =   '/default/data';

                    axios.get(ruta,{                        
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_carga_data   =   respuesta;
                        me.cargarTipoSolicitud();
                        me.cargarPrioridad();
                        me.cargarUbicacion();
                        me.cargarDireccionMunicipal();
                        me.cargarUnidadVecinal();
                        me.cargarVecinos();
                        me.cargarTicket();
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTipoSolicitud()
                {
                    let me  =   this;
                    me.arr_tipos     =   [];
                    me.arr_tipos     =   me.arr_carga_data.arr_tipos;
                },
                //-------------------------------------------------------------------------------------------
                cargarPrioridad()
                {
                    let me  =   this;
                    me.arr_prioridad    =   [];
                    me.arr_prioridad    =   me.arr_carga_data.arr_prioridad;
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicacion()
                {
                    let me  =   this;
                    me.arr_ubicacion    =   [];
                    me.arr_ubicacion    =   me.arr_carga_data.arr_ubicaciones;
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionMunicipal()
                {
                    let me  =   this;
                    me.arr_dir_municipal    =   [];
                    me.arr_dir_municipal    =   me.arr_carga_data.arr_direcciones;
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal()
                {
                    let me  =   this;
                    me.arr_unidadvecinal    =   [];
                    me.arr_unidadvecinal    =   me.arr_carga_data.arr_unidadvecinal;
                },
                //-------------------------------------------------------------------------------------------
                cargarVecinos()
                {
                    let me  =   this;
                    me.arr_persona    =   [];
                    me.arr_persona    =   me.arr_carga_data.arr_vecinos;
                },
                //-------------------------------------------------------------------------------------------
                cargarTicket()
                {
                    let me  =   this;
                    me.arr_ticket    =   [];
                    me.arr_ticket    =   me.arr_carga_data.arr_ticket;
                },
                //-------------------------------------------------------------------------------------------
                callDirecciones(query, tp_opcion = 1)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';
                    var respuesta   = [];

                    axios.post(ruta,{'nm_direccion':   query,
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;

                        if(tp_opcion == 1)
                            me.arr_calles_vecino = respuesta.result;
                        
                        if(tp_opcion == 2)
                            me.arr_calles_solicitud = respuesta.result;

                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                indexDireccionesSolicitud(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.callDirecciones(query,2);
                },
                //-------------------------------------------------------------------------------------------
                indexDireccionesVecino(query)
                {
                    let me          = this;
                    var ruta        = '/direccion/index';

                    if(query.length >= 3) 
                        me.callDirecciones(query,1);
                },
                //-------------------------------------------------------------------------------------------
                cargarHistorial(id_consulta)
                {
                    let me      = this;
                    var ruta    = '/territorial/revisar/historial/solicitud';

                    axios.post(ruta,{
                        'id_solicitud'  :   id_consulta,
                    }).then(function (response) 
                    {
                        var respuesta       =   response.data;
                        me.arr_historial    =   respuesta.arr_historial;
                    }).catch(function (error) 
                    {
                        console.log(error)
                    });     
                },
                //-------------------------------------------------------------------------------------------
                getIdDespacho(data = [])
                {
                    let me      =   this;
                    var nr_id   =   0;

                    if(data.length)
                    {
                        nr_id   =   data[0]['id_despacho'];
                    }

                    return nr_id;
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page)
                {
                    let me      =   this;
                    me.cargarDataDefault();
                    me.cargarIndex(page);
                },
                //-------------------------------------------------------------------------------------------
                cargarIndex(page = 1)
                {
                    let me      =   this;
                    var ruta    =   '/territorial/revisar/solicitud/inicio';

                    axios.post(ruta,{
                            'page'              :   page,
                            'fl_mostrar'        :   me.fl_mostrar,
                            'fl_tipo'           :   me.getValue(me.fl_tipo),
                            'fl_prioridad'      :   me.getValue(me.fl_prioridad),
                            'fl_persona'        :   me.getValue(me.fl_persona),
                            'fl_direccion'      :   me.getValue(me.fl_direccion),
                            'fl_unidadvecinal'  :   me.getValue(me.fl_unidadvecinal),
                            'fl_ticket'         :   me.getValue(me.fl_ticket),
                    }).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_index    =   respuesta.info.data;
                        me.pagination   =   respuesta.pagination;
                        me.rows         =   respuesta.info.data;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(accion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_error    =   [];

                    switch(accion)
                    {
                        case 'asignar':
                        {
                            if(me.id_consulta == 0)
                                me.arr_error.push('No se encuentra el ID de la Solicitud');

                            if(me.nr_id_historia == 0)
                                me.arr_error.push('No se encuentra el ID de Historia');

                            if(me.nr_id_despacho == 0)
                                me.arr_error.push('No se encuentra el ID de Despacho');

                            if(me.nr_id_dir_destino == 0)
                                me.arr_error.push('No se encuentra el ID de la Unidad de destino (Dirección)');

                            if(me.str_obs_asignar.trim().length < 10)
                                me.arr_error.push('La observación debe tener minimo 5 caracteres');

                            if(me.nr_subordinados.length == 0)
                                me.arr_error.push('No se encuentra el ID Estado');

                            break;
                        }
                        case 'observacion':
                        {
                            if(me.id_consulta == 0)
                                me.arr_error.push('No se encuentra el ID de la Solicitud');

                            if(me.nr_id_historia == 0)
                                me.arr_error.push('No se encuentra el ID de Historia');

                            if(me.str_observacion.trim().length < 10)
                                me.arr_error.push('La observación debe tener minimo 10 caracteres');

                            break;
                        }
                        case 'inhabilitar_funcionario':
                        {
                            if(me.nr_id_encargado == 0)
                                me.arr_error.push('No se encuentra el ID de encargado');

                            if(me.nr_id_despacho == 0)
                                me.arr_error.push('No se encuentra el ID de despacho');

                            if(me.nr_id_usuario == 0)
                                me.arr_error.push('No se encuentra el ID del usuario');

                            break;
                        }
                    }

                    if(me.arr_error.length)
                    {
                        error   =   1;
                    }

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me          =   this;
                    var ruta        =   '';
                    var titulo      =   '';
                    var tiempo      =   0;
                    var error       =   0;
                    me.tp_error     =   0;
                    var formData    =   new FormData();
                    var fc_format   =   'YYYY-MM-DD';

                    if(me.nr_tp_direccion_solicitud == 2)
                        {
                            dir_solicitud       = me.dir_1+' && '+me.dir_2;
                            nr_dir_solicitud    = 1
                        }

                    switch(accion)
                    {
                        case 'asignar':
                        {
                            titulo      =   'Asignar Funcionario';
                            tiempo      =   3000;
                            error       =   me.validarDatos(accion);                            
                            console.log(error)

                            if(error == 1)
                            {
                                me.tp_error     =   1;
                                me.abrirModal('mensaje','alerta');
                            }
                            else
                            {
                                //------------------------------------
                                me.tp_btn   =   1;
                                ruta        =   '/territorial/revisar/solicitud/asignar';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('id_solicitud', me.id_consulta);
                                formData.append('id_historia', me.nr_id_historia);
                                formData.append('id_despacho', me.nr_id_despacho);
                                formData.append('id_direccion_destino', me.nr_id_dir_destino);
                                formData.append('str_obs_asignar', me.str_obs_asignar);                                
                                //------------------------------------
                                if(me.nr_subordinados.length != 0)
                                {
                                    for (var i = 0; i < me.nr_subordinados.length; i++)
                                    {
                                        formData.append('arr_subordinados['+i+']', me.nr_subordinados[i].value);
                                    }
                                }
                                //------------------------------------
                                me.cerrarModal('secundario');
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'observacion':
                        {
                            titulo      =   'Registrar Observación';
                            tiempo      =   3000;
                            error       =   me.validarDatos(accion);

                            if(error == 1)
                            {
                                me.tp_error     =   1;
                                me.abrirModal('mensaje','alerta');
                            }
                            else
                            {
                                //------------------------------------
                                ruta    =   '/territorial/revisar/solicitud/observacion';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('id_solicitud', me.id_consulta);
                                formData.append('id_historia', me.nr_id_historia);
                                formData.append('id_despacho', me.nr_id_despacho);
                                formData.append('str_observacion', me.str_observacion);
                                formData.append('tp_observacion', me.tp_observacion);
                                formData.append('tp_gestionar', me.tp_solicitud_gestionada);
                                formData.append('tp_informar', me.tp_informar);
                                //------------------------------------
                                if(me.arr_files.length != 0)
                                {
                                    for (var i = 0; i < me.arr_files.length; i++) 
                                    {
                                        formData.append('arr_archivo[]', me.arr_files[i]);
                                    }
                                    for (var i = 0; i < me.arr_files_obs.length; i++) 
                                    {
                                        formData.append('arr_observacion[]', me.arr_files_obs[i]);
                                    }
                                }
                                //------------------------------------
                                me.cerrarModal('secundario');
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'inhabilitar_funcionario':
                        {
                            titulo      =   'Liberar Funcionario';
                            tiempo      =   3000;
                            error       =   me.validarDatos(accion);

                            if(error == 1)
                            {
                                me.tp_error     =   1;
                                me.abrirModal('mensaje','alerta');
                            }
                            else
                            {
                                //------------------------------------
                                ruta    =   '/territorial/revisar/solicitud/funcionario/inhabilitar';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_encargado', me.nr_id_encargado);
                                formData.append('nr_despacho', me.nr_id_despacho);
                                formData.append('nr_usuario', me.nr_id_usuario);
                                //------------------------------------
                                me.cerrarModal('validacion');
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me          =       this;
                    var tp_icon     =       '';
                    var titulo      =       '';
                    var mensaje     =       '';
                    var tiempo      =       0;

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        console.log(response);
                        var r  =   response.data;

                        if(r.error == 0)
                        {
                            titulo      =   r.title;
                            mensaje     =   r.msj;
                            me.desplegarVentana('success', titulo, mensaje);
                            me.cargarDatos();

                            if(me.tp_modal == 2 || me.tp_modal == 3) me.cargarHistorial(me.id_consulta);
                        }
                        else
                        {
                            titulo      =   r.title;
                            mensaje     =   r.msj;
                            me.desplegarVentana('error', titulo, mensaje);
                            me.cargarDatos();

                            if(me.tp_modal == 2) me.cargarHistorial(me.id_consulta);
                        }
                    })
                    .catch(function (error) 
                    {
                        // Faltan campos por llenar
                        if (error.response.status == 422)
                        {
                            me.arr_valida   =   error.response.data.errors;
                        }
                        // Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            // ---------------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =       this;

                    switch(modelo)
                    {
                        case 'solicitud':
                        {
                            me.tp_modal     =   1;

                            switch(accion)
                            {
                                case 'informacion':
                                {
                                    me.arr_historial                =   [];
                                    console.log(data);
                                    me.solicitud_actual             =   data;
                                    me.id_consulta                  =   data.id;
                                    me.cargarHistorial(me.id_consulta);
                                    me.rut_vecino                   =   data.vecino.nr_rut;
                                    me.nm_vecino                    =   data.vecino.nm_vecino;
                                    me.ap_paterno                   =   data.vecino.ap_paterno;
                                    me.ap_materno                   =   data.vecino.ap_materno;
                                    me.nr_telefono                  =   data.vecino.nr_telefono;
                                    me.pre_fijo                     =   data.vecino.nr_prefijo;
                                    me.mail_vecino                  =   data.vecino.nm_mail;
                                    me.str_aclaratoria              =   data.vecino.str_aclaratoria;                                    
                                    me.tp_municipal                 =   data.tp_municipal;                                    
                                    me.nr_estado                    =   data.id_estado;
                                    me.nr_tp_direccion_solicitud    =   data.tp_direccion;                                    
                                    me.str_observacion              =   data.str_observacion; 
                                    me.nr_id_autor                  =   data.id_autor;
                                    me.tp_visado                    =   data.tp_visado;
                                    me.tp_solicitud_gestionada      =   data.solicitud_gestionada;

                                    me.nr_tipo                  =   {
                                        value : data.nr_tipo,
                                        label : data.nm_tipo,
                                    }

                                    me.nr_prioridad             =   {
                                        value : data.prioridad.id,
                                        label : data.prioridad.nm_prioridad,
                                    }

                                    me.nr_dir_municipal         =   {
                                        value : data.id_direccion_destino,
                                        label : data.nm_direccion_destino,
                                    }

                                    me.arr_direccion_solicitud =    {
                                        value : data.id_ubicacion,
                                        label : data.nm_ubicacion,
                                        nr_calle : data.nr_direccion,
                                        nm_calle : data.nm_direccion,
                                        str_latitud : data.str_latitud,
                                        str_longitud : data.str_longitud,
                                        cod_territorial : data.id_macroterritorio,
                                        cod_unidadvecinal : data.id_unidadvecinal,
                                    }

                                    me.arr_ubicacion_vecino     =   {
                                        value : data.vecino.id_ubicacion,
                                        label : data.vecino.nm_ubicacion,
                                        nr_calle : data.vecino.nr_calle,
                                        nm_calle : data.vecino.nm_calle,
                                        str_latitud : data.vecino.str_latitud,
                                        str_longitud : data.vecino.str_longitud,
                                        cod_territorial : data.vecino.id_macroterritorio,
                                        cod_unidadvecinal : data.vecino.id_unidadvecinal,
                                    }

                                    
                                    me.titulo_principal     =   'Información de la Solicitud';
                                    me.boton_principal      =   2;
                                    me.arr_archivo          =   [];
                                    me.changeContexto();

                                    $('#modal_principal').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'historial':
                        {
                            me.tp_modal     =   2;

                            switch(accion)
                            {
                                case 'finalizar':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_secundario      =   1;
                                    me.accion_secundario     =   1;
                                    me.boton_secundario      =   1;
                                    me.titulo_secundario     =   'Registrar Respuesta';
                                    me.id_consulta           =   data.id_solicitud;
                                    me.nr_id_historia        =   data.id;
                                    me.tp_observacion        =   1;
                                    me.tp_informar           =   false;

                                    if(!data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.encargado);
                                    else if(data.gestor.length && !data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);
                                    else if(data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);

                                    $('#modal_secundario').modal('show');
                                    console.log(me.nr_id_despacho);

                                    break;
                                }
                                case 'responder':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_secundario      =   1;
                                    me.accion_secundario     =   1;
                                    me.boton_secundario      =   1;
                                    me.titulo_secundario     =   'Registrar Respuesta';
                                    me.id_consulta           =   data.id_solicitud;
                                    me.nr_id_historia        =   data.id;
                                    me.tp_observacion        =   2;
                                    me.tp_informar           =   false;

                                    if(!data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.encargado);
                                    else if(data.gestor.length && !data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);
                                    else if(data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);

                                    $('#modal_secundario').modal('show');
                                    console.log(me.nr_id_despacho);

                                    break;
                                }
                                case 'observacion':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_secundario      =   1;
                                    me.accion_secundario     =   1;
                                    me.boton_secundario      =   1;
                                    me.titulo_secundario     =   'Registrar Observación';
                                    me.id_consulta           =   data.id_solicitud;
                                    me.nr_id_historia        =   data.id;
                                    me.tp_observacion        =   3;
                                    me.tp_informar           =   false;

                                    if(!data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.encargado);
                                    else if(data.gestor.length && !data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);
                                    else if(data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);
                                    
                                    $('#modal_secundario').modal('show');

                                    break;
                                }
                                case 'asignar':
                                {
                                    me.limpiarDatos(accion);
                                    console.log(data);
                                    me.tp_btn                =   0;
                                    me.modal_secundario      =   1;
                                    me.accion_secundario     =   2;
                                    me.boton_secundario      =   2;
                                    me.titulo_secundario     =   'Asignar Funcionario';
                                    me.id_consulta           =   data.id_solicitud;
                                    me.nr_id_historia        =   data.id;
                                    me.nr_id_dir_destino     =   data.id_direccion_destino;
                                    me.tp_informar           =   false;

                                    if(!data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.encargado);
                                    else if(data.gestor.length && !data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);
                                    else if(data.gestor.length && data.encargado.length)
                                        me.nr_id_despacho    =   me.getIdDespacho(data.gestor);

                                    me.cargarSubordinados();
                                    $('#modal_secundario').modal('show');

                                    break;
                                }
                                case 'inhabilitar':
                                {
                                    me.modal_validacion     =   1;
                                    me.accion_validacion    =   1;
                                    me.boton_validacion     =   1;
                                    me.titulo_validacion    =   'Liberar Funcionario';
                                    me.mensaje_validacion   =   '¿Esta seguro de liberar al funcionario "' + data.nm_encargado + '"?';
                                    me.nr_id_encargado      =   data.id;
                                    me.nr_id_despacho       =   data.id_despacho;
                                    me.nr_id_usuario        =   data.id_encargado;
                                    me.tp_informar          =   false;
                                    $('#modal_validacion').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'archivo':
                        {
                            me.tp_modal     =   3;

                            switch(accion)
                            {
                                case 'anexar':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   1;
                                    me.titulo_adjunto       =   'Adjuntar Documentos';
                                    me.tp_adjunto           =   'documento';
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                                case 'revisar':
                                {
                                    me.limpiarDatos(accion);
                                    me.modal_adjunto        =   1;
                                    me.accion_adjunto       =   2;
                                    me.titulo_adjunto       =   'Revisar Documentos';
                                    me.tp_adjunto           =   'archivos';
                                    me.arr_archivo          =   data.archivos;
                                    $('#modal_adjunto').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                        case 'mensaje':
                        {
                            me.tp_modal     =   4;

                            switch(accion)
                            {
                                case 'alerta':
                                {
                                    me.modal_mensaje    =   1;
                                    me.accion_mensaje   =   1;
                                    me.titulo_mensaje   =   'Validación de información';
                                    $('#modal_mensaje').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'informacion':
                        {
                            me.modal_principal        =   0;
                            me.accion_principal       =   0;
                            me.boton_principal        =   0;
                            me.titulo_principal       =   '';
                            $('#modal_principal').modal('hide');

                            break;
                        }
                        case 'archivo':
                        {
                            me.modal_adjunto        =   0;
                            me.accion_adjunto       =   0;
                            me.boton_adjunto        =   0;
                            me.titulo_adjunto       =   '';
                            $('#modal_adjunto').modal('hide');

                            break;
                        }
                        case 'mensaje':
                        {
                            me.modal_mensaje        =   0;
                            me.accion_mensaje       =   0;
                            me.titulo_mensaje       =   '';
                            $('#modal_mensaje').modal('hide');

                            break;
                        }
                        case 'secundario':
                        {
                            me.modal_secundario     =   0;
                            me.accion_secundario    =   0;
                            me.titulo_secundario    =   '';
                            me.boton_secundario     =   0;
                            $('#modal_secundario').modal('hide');

                            break;
                        }
                        case 'validacion':
                        {
                            me.modal_validacion        =   0;
                            me.accion_validacion       =   0;
                            me.boton_validacion        =   0;
                            me.titulo_validacion       =   '';
                            $('#modal_validacion').modal('hide');

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(accion)
                {
                    let me  =   this;

                    switch(accion)
                    {
                        case 'informacion':
                        {
                            me.arr_info             =   [];

                            break;
                        }
                        case 'anexar':
                        {
                            me.arr_files            =   [];
                            me.arr_files_obs        =   [];
                            me.file_observacion     =   '';

                            break;
                        }
                        case 'revisar':
                        {
                            me.arr_archivo  =   [];

                            break;
                        }
                        case 'asignar':
                        {
                            me.id_consulta          =   0;
                            me.nr_id_historia       =   0;
                            me.nr_id_dir_destino    =   0;
                            me.nr_id_despacho       =   0;
                            me.str_obs_asignar      =   '';
                            me.nr_subordinados      =   [];

                            break;
                        }
                        case 'finalizar':
                        case 'responder':
                        case 'observacion':
                        {
                            me.id_consulta          =   0;
                            me.nr_id_historia       =   0;
                            me.tp_observacion       =   0;
                            me.str_observacion      =   '';
                            me.file_observacion     =   '';
                            me.arr_archivo          =   [];
                            me.arr_files            =   [];
                            me.arr_files_obs        =   [];
                            me.descartarAdjunto();

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje)
                {
                    let me          =   this;
                    var tp_btn      =   true;

                    /*
                        icon list
                        - success 
                        - error 
                        - warning 
                        - info 
                        - question
                    */

                    Swal.fire({
                        type: tp_icon,
                        title: titulo,
                        text: mensaje,
                        showConfirmButton: tp_btn
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDatos();
                me.cargarDataDefault();
                $('.tp_bloquear').prop('disabled',true);
                //$('select').not('.estados').attr('disabled',true);
                //$('textarea').attr('disabled',true);
                $('button').not('.btn_activo').attr('disabled',true);

            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------
                });
            });
            /*----- Inicio - Modal -----*/
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
    </script>
    
@endsection()


