<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('estado/listado', 'GsutEstadoController@listado');
Route::get('regiones/listado', 'UtilController@listadoRegiones');
Route::post('comunas/listado', 'UtilController@listadoComunas');
Route::get('satisfaccion/listado', 'UtilController@listarNivelSatisfaccion');
Route::get('motivo/listado', 'GsutMotivoController@listado');
Route::get('servicios/listado', 'GsutTipoController@listadoServicios');
Route::post('direccion/buscar', 'MaestroDireccionesController@index');

Route::group(['middleware' => ['apiuser']], function() {
	Route::post('solicitud/registrar', 'ApiController@storeSolicitud');
	Route::post('solicitud/detalle', 'ApiController@detailSolicitud');
	Route::get('solicitud/archivo', 'ArchivosController@getPreview');
	Route::post('solicitud/feedback_vecino', 'ApiController@storeFeedbackVecino');

	Route::post('solicitudes/vecino', 'ApiController@getSolicitudes');
	Route::post('solicitudes/ticket/vecino', 'ApiController@getTicket');

	Route::get('solicitudes/activas', 'ApiController@getSolicitudesActivas');
});





