<?php $__env->startSection('body'); ?>
    <div class="page-content">
        <div class="container-fluid" id="app">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0 font-size-18">Exportar Datos</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Exportar Datos</a></li>
                                <li class="breadcrumb-item active">Solicitudes</li>
                            </ol>
                        </div>
                    </div>

                    <!-- Filtros -->
                    <div class="card">
                        <div class="card-header bg-primary">
                            <div class="col-md-12 col-sm-12 text-center">
                                <h5 style="color:white;">Filtros de Exportación</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row ml-2 mr-2">
                                <!-- Filtro por Estado -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Estado Requerimiento
                                        </label>
                                        <select v-model="fl_mostrar" class="form-control estados">
                                            <option v-for="item in arr_mostrar" :value="item.value" v-text="item.label"></option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Filtro por Rango de Fechas -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Rango de Fechas (Solo 150 dias posteriores)
                                        </label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="fc_desde" id="fc_desde" placeholder="Desde" />
                                            <input type="text" class="form-control" name="fc_hasta" id="fc_hasta" placeholder="Hasta" />
                                        </div>
                                    </div>
                                </div>
                                <!-- Filtro de Orden -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Ordenar Por
                                        </label>
                                        <div class="input-group">
                                            <select v-model="tp_criterio" class="form-control">
                                                <option value="id">Ticket</option>
                                                <option value="id_macroterritorio">Macrozona</option>
                                                <option value="id_unidadvecinal">Unidad Vecinal</option>
                                                <option value="nm_direccion">Dirección Municipal</option>
                                                <option value="nm_depto">Depto. Municipal</option>
                                                <option value="nm_estado">Estado</option>
                                                <option value="created_at">Fecha Ingreso</option>
                                            </select>
                                            <select v-model="tp_orden" class="form-control">
                                                <option value="ASC">Ascendente</option>
                                                <option value="DESC">Descendente</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <!-- Dirección Municipal -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Dirección Municipal :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_direccion"
                                            :options="arr_direccion" 
                                            @select="asyncDeptos" 
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Dirección Municipal"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Depto Municipal -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Depto Municipal :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_depto"
                                            :options="arr_depto" 
                                            @select="asyncServicios" 
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Depto Municipal"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Servicio -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Servicio :
                                        </label>
                                        <multiselect
                                            :show-labels="false" 
                                            :searchable="true" 
                                            v-model="fl_servicio" 
                                            :options="arr_servicio" 
                                            :multiple="false" 
                                            :showNoOptions="false" 
                                            placeholder="Servicio" 
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Macrozona -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Macrozona :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_macrozona"
                                            :options="arr_macrozona"
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Unidad Vecinal"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Unidad Vecinal -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Unidad Vecinal :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_unidadvecinal"
                                            :options="arr_unidadvecinal"
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Unidad Vecinal"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Ticket -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            N° Ticket :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_ticket"
                                            :options="arr_ticket"
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="N° Ticket"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Solicitante -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Solicitante :
                                        </label>
                                        <multiselect
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_persona"
                                            :options="arr_persona"
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Solicitante"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Motivo -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Tipo Requerimiento :
                                        </label>
                                        <multiselect
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_motivo"
                                            :options="arr_motivo"
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Tipo Requerimiento"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Ubicación del Problema -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Dirección del Requerimiento :
                                        </label>
                                        <multiselect
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_ubicacion"
                                            :options="arr_ubicaciones"
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Dirección del Requerimiento"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Opciones de Exportacion -->
                    <div class="card">
                        <div class="card-body">
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <div class="row">
                                    <div class="form-group ml-5 mr-5">
                                        <!-- Exportacion de Solicitudes -->
                                        <div class="col-lg-3 col-md-4 col-sm-4" style="align-items: center; align-content: center;text-align: center;">
                                            <button id="btn_exportar_solicitudes" @click="generarRuta()" class="btn btn-success col-12">
                                                <i class="fas fa-file-download fa-2x ml-2 mr-2 mt-2 mb-2"></i>
                                                <span class="h5 ml-2 mr-2 mt-2 mb-2">Ver Solicitudes</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>                  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'DESC',
                //-------------------------------------
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_servicio                :   [],
                arr_motivo                  :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                arr_persona                 :   [],
                arr_ubicaciones             :   [],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'DESC',
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Ingresada',
                    },
                    {
                        'value'     :   2,
                        'label'     :   'Por Asignar',
                    }, 
                    {
                        'value'     :   3,
                        'label'     :   'En Gestión',
                    },
                    {
                        'value'     :   4,
                        'label'     :   'En Revisión',
                    },
                    {
                        'value'     :   5,
                        'label'     :   'Cerrado',
                    },
                    {
                        'value'     :   6,
                        'label'     :   'Terminado',
                    },
                    {
                        'value'     :   7,
                        'label'     :   'Anulada',
                    },
                ],
                fl_mostrar                  :   0,
                //-------------------------------------
                str_ruta                    : '#',
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                activeDatetimepicker()
                {
                    let fc_format1  =   'DD-MM-YYYY';
                    let fc_format2  =   'd-m-Y';
                    let fc_date     =   moment().locale('es').format(fc_format1);
                    let fc_desde    =   '';
                    let fc_hasta    =   '';
                    //-----------------------------------
                    fc_hasta = fc_date;
                    fc_desde = moment().subtract(90, 'days').format(fc_format1);
                    //-----------------------------------

                    // Configuración base para flatpickr
                    let baseConfig = {
                        dateFormat: fc_format2,
                        locale: 'es',  // Asegúrate de tener el locale de 'es' cargado si lo necesitas.
                        allowInput: true,  // Permite la entrada manual de la fecha
                    };

                    // Configuración para "Desde"
                    let desdeConfig = Object.assign({}, baseConfig, {
                        defaultDate: fc_desde,
                    });
                    flatpickr('#fc_desde', desdeConfig);

                    // Configuración para "Hasta"
                    let hastaConfig = Object.assign({}, baseConfig, {
                        defaultDate: fc_hasta,
                        maxDate: new Date(),  // Fecha máxima es la fecha actual
                    });
                    flatpickr('#fc_hasta', hastaConfig);
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_direccion         =   [];
                    me.fl_depto             =   [];
                    me.fl_servicio          =   [];
                    me.fl_macrozona         =   [];
                    me.fl_unidadvecinal     =   [];
                    me.fl_ticket            =   [];
                    me.arr_depto            =   [];
                    me.arr_servicio         =   [];
                    me.fl_ubicacion         =   [];
                    me.fl_motivo            =   [];
                    me.fl_persona           =   [];
                    me.fl_mostrar           =   0;
                    me.tp_criterio          =   'created_at';
                    me.tp_orden             =   'DESC';
                    activeDatepicker();
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.fl_direccion));                        
                        me.arr_servicio     =   [];
                        me.fl_depto         =   [];
                        me.fl_servicio      =   [];
                    }
                    else
                    {
                        me.fl_depto         =   [];
                        me.fl_servicio      =   [];
                        me.arr_depto        =   [];
                        me.arr_servicio     =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_depto     =   item;
                        me.cargarServicios(me.getValue(me.fl_direccion), me.getValue(me.fl_depto));
                        me.fl_servicio  =   [];
                    }
                    else
                    {
                        me.fl_servicio  =   [];
                        me.fl_servicio  =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales()
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.direcciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(tp_filtro = 0, nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;

                        if(tp_filtro == 0)
                            me.arr_depto        =   respuesta.deptos;
                        else
                            me.fl_arr_deptos    =   respuesta.deptos;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/servicios';
                    me.arr_servicio     =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me      =   this;
                    var ruta    =   '/motivo/listado';
                    me.arr_motivo   =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMacrozona()
                {
                    let me      =   this;
                    var ruta    =   '/listado/macrozona';
                    me.arr_macrozona    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_macrozona    =   respuesta.macrozona;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal()
                {
                    let me      =   this;
                    var ruta    =   '/listar/unidadvecinales';
                    me.arr_unidadvecinal    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_unidadvecinal    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTicket()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ticket';
                    me.arr_ticket    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta    =   response.data;
                        me.arr_ticket    =   respuesta.ticket;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicaciones()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ubicaciones';
                    me.arr_ubicaciones      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_ubicaciones      =   respuesta.ubicaciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPersonas()
                {
                    let me      =   this;
                    var ruta    =   '/listado/personas';
                    me.arr_persona      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_persona      =   respuesta.personas;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                generarRuta()
                {
                    let me          =   this;
                    me.str_ruta     =   '#';
                    var ruta        =   '/exportar/solicitudes?';

                    if(!(document.querySelector('#fc_desde').value) || !(document.querySelector('#fc_hasta').value))
                    {
                        me.desplegarVentana('warning','Extracción de Datos','Debe indicar el rango de Fecha');
                        return;
                    }

                    ruta    =   ruta
                                + 'tp_criterio=' + me.tp_criterio 
                                + '&tp_orden=' + me.tp_orden 
                                + '&fl_mostrar=' + me.fl_mostrar 
                                + '&fc_desde=' + document.querySelector('#fc_desde').value 
                                + '&fc_hasta=' + document.querySelector('#fc_hasta').value 
                                + '&fl_direccion=' + me.getValue(me.fl_direccion) 
                                + '&fl_depto=' + me.getValue(me.fl_depto) 
                                + '&fl_servicio=' + me.getValue(me.fl_servicio) 
                                + '&fl_macrozona=' + me.getValue(me.fl_macrozona) 
                                + '&fl_unidadvecinal=' + me.getValue(me.fl_unidadvecinal) 
                                + '&fl_ticket=' + me.getValue(me.fl_ticket) 
                                + '&fl_persona=' + me.getValue(me.fl_persona) 
                                + '&fl_motivo=' + me.getValue(me.fl_motivo) 
                                + '&fl_ubicacion=' + me.getValue(me.fl_ubicacion);

                    window.open(ruta, '_blank');
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.activeDatetimepicker();
                me.cargarDireccionesMunicipales();
                me.cargarDeptosMunicipales(0,0);
                me.cargarServicios(0,0);
                me.cargarMotivo();
                me.cargarMacrozona();
                me.cargarUnidadVecinal();
                me.cargarTicket();
                me.cargarUbicaciones();
                me.cargarPersonas();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        //-----------------------------------------------------------------
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\repositorio\atencion_vecino\resources\views/administrador/exportar_administrador.blade.php ENDPATH**/ ?>