<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">Gestionar Encuestadores</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Gestionar Encuestadores</a></li>
                            <li class="breadcrumb-item active">Encuestadores</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros Especificos -->
                <div class="row mb-3 not-print">
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align:left;">
                        <!-- No se realizaran filtros por estado -->
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-6" style="text-align: left;">
                        <!-- No se realizaran filtros por rango de fechas -->
                    </div>
                    <div class="col-lg-4 col-md-6 col-sm-6" style="text-align:right;">
                        <!-- No se realizaran filtros por orden de campos -->
                    </div>
                    <div class="col-lg-2 col-md-6 col-sm-6" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos(pagination.current_page);">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>
                    </div>                        
                </div>

                <!-- Llamadas Realizadas -->
                <div class="col-md-12 col-sm-12">
                    <div class="row">
                        <div class="col-md-12 col-sm-12">
                            <div class="card">
                                <div class="card-header bg-primary m-0 p-1">
                                    <div class="text-center text-white font-weight-bold font-size-18">
                                        Encuestadores Habilitados para la Encuesta de Servicio
                                    </div>
                                </div>
                                <div class="card-body m-0 p-2">
                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 col-sm-1"></div>
                                        <div class="col-lg-6 col-md-6 col-sm-10"><!-- Telefonisas -->
                                            <div class="col-md-12 text-center font-size-14 mb-3">
                                                <div class="row">
                                                    <div class="col-md-8 col-sm-12 mt-2">
                                                        <multiselect 
                                                            :show-labels="false"
                                                            :searchable="true"
                                                            v-model="nr_telefonista"
                                                            :options="arr_telefonista" 
                                                            :multiple="false"
                                                            :showNoOptions=false
                                                            placeholder="Encuestador"
                                                            label="label" track-by="label">
                                                                <span slot="noResult">No se han encontrado resultados</span>
                                                        </multiselect>
                                                    </div>
                                                    <div class="col-md-4 col-sm-12 mt-2">
                                                        <button v-if="btn_envio == 0" class="btn btn-md btn-sm btn-success" type="button" @click="ensamblarDatos('agregar')">
                                                            <span class="h5 text-white">Agregar Encuestador</span>
                                                        </button>
                                                        <button v-else type="button"  class="btn btn-warning"><i class="fas fa-spin fa-spinner"></i> Agregando Encuestador</button>
                                                    </div>
                                                    <div class="col-md-12 col-sm-12 text-center">
                                                        <small class="text-error text-danger" v-if="arr_form.nr_telefonista"  v-text="arr_form.nr_telefonista"></small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-1"></div>

                                        <div class="col-md-12 col-sm-12 text-center pb-2">
                                            <span class="h3 text-primary font-weight-bold">Ticket Sin Asignar : {{ nr_cantidad_ticket }}</span>
                                        </div>

                                        <!-- Opciones de Distribucion de Ticket de Atención -->
                                        <div class="col-md-12 col-sm-12 text-center pb-2">
                                            <div class="row">
                                                <div class="col-lg-3 col-md-3 col-sm-1"></div>
                                                <div class="col-lg-6 col-md-6 col-sm-10">
                                                    <div class="dropdown">
                                                        <button class="btn btn-secondary col-lg-8 col-md-8 col-sm-12" v-if="btn_distribuir == 0"
                                                            type="button" id="menu_opcion" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <span class="h4 text-white">Distribución de Ticket <i class="mdi mdi-chevron-down"></i></span>
                                                        </button>
                                                        <button v-else type="button" class="btn btn-warning">
                                                            <span class="h4 text-white"><i class="fas fa-spin fa-spinner"></i> Realizando Distribución de Ticket
                                                        </button>
                                                    
                                                        <div class="dropdown-menu" :class="{'hide':btn_distribuir == 1}" aria-labelledby="menu_opcion">
                                                            <!-- Distribucion de carga de trabajo por equidad -->
                                                            <a href="#" class="dropdown-item" 
                                                                @click="abrirModal('telefonista','distribuir_equidad')">
                                                                <span class="h5">
                                                                    <i class="fas fa-history" style="color: blue;"></i> 
                                                                    Distribución por Equidad de Trabajo
                                                                </span>
                                                            </a>
                                                            <!-- Distribucion de carga de trabajo por igualdad -->
                                                            <a href="#" class="dropdown-item" 
                                                                @click="abrirModal('telefonista', 'distribuir_igualdad')">
                                                                <span class="h5">
                                                                    <i class="fas fa-edit" style="color: green;"></i> 
                                                                    Distribución por Igualdad de Carga de Trabajo
                                                                </span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-1"></div>
                                            </div>
                                        </div>

                                        <!-- Tabla de Datos y Paginacion -->
                                        <div class="col-md-12 col-sm-12">
                                            <div class="row">
                                                <!-- Tabla de Datos -->
                                                <div class="responsive-table">
                                                    <table  class="table table-bordered border-info table-striped table-sm table-hover bl-1">
                                                        <thead class="bg-primary">
                                                            <th colspan="15" >
                                                                <h6 class="text-center font-size-14 mt-2" style="color:white" >
                                                                    Resumen Global de Encuestas
                                                                </h6>
                                                            </th>
                                                        </thead>
                                                        <thead class="bg-primary font-size-14"  style="color:white">
                                                            <th class="text-center"> # </th>
                                                            <th class="text-center">Nombre</th>
                                                            <th class="text-center">Ap. Paterno</th>
                                                            <th class="text-center">Ap. Materno</th>
                                                            <th class="text-center">Total Ticket</th>
                                                            <th class="text-center">Pendientes</th>
                                                            <th class="text-center">Parciales</th>
                                                            <th class="text-center">Reagendados</th>
                                                            <th class="text-center">Rechazados</th>
                                                            <th class="text-center">No Contactado</th>
                                                            <th class="text-center">Encuestas Realizadas</th>
                                                            <th class="text-center">Total Atendidos</th>
                                                            <th class="text-center">Opción</th>
                                                        </thead>
                                                        <tbody>
                                                            <template v-if="arr_index.length">
                                                                <tr class="font-size-16" v-for="(datos, index) in arr_index" :key="datos.id">
                                                                    <td style="text-align:center;">
                                                                        {{ (index + 1) }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.nombre }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.ap_paterno }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.ap_materno }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_ticket }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_pendientes }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_parciales }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_reagendados }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_rechazados }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_no_contactados }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_terminados }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        {{ datos.cant_atendidos }}
                                                                    </td>
                                                                    <td style="text-align:center;">
                                                                        <button type="button" class="btn btn-danger waves-effect waves-light" title="Quitar" 
                                                                            @click="abrirModal('telefonista','quitar',datos)">
                                                                            <i class="fas fa-portrait"></i> Quitar
                                                                        </button>
                                                                        <button type="button" class="btn btn-warning waves-effect waves-light" title="Asignación" 
                                                                            @click="abrirModal('telefonista','modal_asignacion',datos)">
                                                                            <i class="fas fa-portrait"></i> Asignación
                                                                        </button>
                                                                    </td>
                                                                </tr>
                                                            </template>
                                                            <template v-else>
                                                                <tr>
                                                                    <td colspan="15">
                                                                        <h5 class="text-center">
                                                                            No hay datos para listar
                                                                        </h5>
                                                                    </td>
                                                                </tr>
                                                            </template>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <!-- Paginacion -->
                                                <div class="col-md-12 col-sm-12">
                                                    <nav>
                                                        <ul class="pagination">
                                                            <li class="page-item" v-if="pagination.current_page > 1">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(1)">Primera</a>
                                                            </li>
                                                            <li class="page-item" v-if="pagination.current_page > 1">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page - 1)">Ant</a>
                                                            </li>
                                                            <li class="page-item" v-for="page in pagesNumber" :key="page" :class="[page == isActivedPagination ? 'active' : '']">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(page, 1)" v-text="page"></a>
                                                            </li>
                                                            <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.current_page + 1)">Sig</a>
                                                            </li>
                                                            <li class="page-item" v-if="pagination.current_page < pagination.last_page">
                                                                <a class="page-link" href="#" @click.prevent="cambiarPagina(pagination.last_page)">Ultima</a>
                                                            </li>
                                                        </ul>
                                                    </nav>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal" tabindex="-1" id="modal_asignacion">
            <div class="modal-dialog modal-lg" style="margin-top: 10%">
                <div class="modal-content" style="border-color: darkgray;">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">Asignar Cantidad de Ticket</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="col-md-12 col-sm-12 mt-2">
                            <div class="row-flow">
                                <div class="col-md-12 col-sm-12 mr-3 ml-3 text-center">
                                    <span class="h4 text-secundary">Cantidad de Ticket Disponibles para asignar : {{ nr_cantidad_ticket }}</span>
                                </div>
                                <div class="col-md-12 col-sm-12 text-center">
                                    <div class="row">
                                        <div class="col-lg-3 col-md-3 col-sm-1"></div>
                                        <div class="col-lg-6 col-md-6 col-sm-10">
                                            <input type="text" maxlength="25" placeholder="Ingrese Cantidad" class="form-control" style="text-align: right; font-size: large; width: 50%; display: inline-block;" 
                                                v-model="nr_distribucion" onkeypress="return justNumbers(event);">
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-1"></div>
                                    </div>
                                    <small class="text-error text-danger font-size-14" v-if="arr_form.nr_distribucion"  v-text="arr_form.nr_distribucion"></small>
                                </div>
                                <div class="col-md-12 col-sm-12 mt-1 text-center">
                                    <button v-if="btn_asignar == 0" @click="ensamblarDatos('asignar')"  class="btn btn-sm btn-primary">
                                        <span class="h5 text-white">Asignar Cantidad <i class="bx bxs-send"></i></span>
                                    </button>
                                    <button v-else class="btn btn-sm btn-danger">
                                        <span class="h5 text-white">Asignando <i class="bx bx-loader-circle"></i></span>
                                    </button>
                                </div>
                            </div>                          
                        </div>
                    </div>
                    <div class="modal-footer">                        
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <style type="text/css">
        .bg-color-skyblue {
            background: skyblue;
        }

        .bg-color-khaki {
            background: khaki;
        }

        .bg-color-darkseagreen {
            background: darkseagreen;
        }

        .bg-color-indianred {
            background: indianred;
        }
    </style>

    <script type="text/javascript">
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {
                //-------------------------------------
                tp_modal                    :   0,
                tp_accion                   :   0,
                tp_btn                      :   0,
                titulo_modal                :   '',
                btn_envio                   :   0,
                btn_distribuir              :   0,
                btn_asignar                 :   0,
                //-------------------------------------
                arr_valida                  :   [],
                arr_error                   :   [],
                arr_form                    :   {},
                str_msj                     :   '',
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                arr_solicitud               :   [],
                arr_historial               :   [],
                arr_respuestas              :   [],
                arr_usuario                 :   [],
                arr_archivo                 :   [],
                //-------------------------------------
                arr_telefonista_habilitados :   [],
                arr_telefonista_agregar     :   [],
                list_telefonista            :   [],
                arr_telefonista             :   [],
                tp_distribucion             :   0,
                nr_distribucion             :   0,
                nr_telefonista              :   null,
                nr_registro                 :   0,
                nm_registro                 :   '',
                nr_cantidad_ticket          :   0,
                //-------------------------------------
                arr_index                   :   [],
                //-------------------------------------
            },

            components: {
                Multiselect: window.VueMultiselect.default
            },

            filters:{
                resumir: function (texto, limite=300, final=' ...')
                {
                    let me  = this;
                    var largo = texto.toString().length;
                    if(largo > limite){
                        for (var i = 0; i < largo; i++) {
                            if(texto[i] == ' ' && i >= limite) {
                                texto   =   texto.substring(0,i);
                                texto   =   texto + final;
                                return texto;
                            }
                        }                    
                    }
                    return texto;
                },

                capitalize: function (str_texto) 
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },

                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },                
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                isActiveTinyMCE()
                {
                    let me      =   this;
                    var valida  =   0;

                    try{
                        if(tinyMCE.activeEditor != null)
                            valida   =   1;
                    }catch(error) {
                        valida  =   0;
                    }   

                    return valida;
                },
                //-------------------------------------------------------------------------------------------
                imprimir(str_modal = "modal_estadistica")
                {
                    $("#"+str_modal).printThis({
                        debug: false,               // show the iframe for debugging
                        importCSS: true,            // import parent page css
                        importStyle: true,          // import style tags
                        printContainer: false,      // print outer container/$.selector
                        loadCSS: "",                // path to additional css file - use an array [] for multiple
                        pageTitle: "",              // add title to print page
                        removeInline: true,        // remove inline styles from print elements
                        removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                        printDelay: 333,            // variable print delay
                        header: null,               // prefix to html
                        footer: null,               // postfix to html
                        base: 'https://atencionvecino.lascondes.cl/',                // preserve the BASE tag or accept a string for the URL
                        formValues: true,           // preserve input/form values
                        canvas: false,              // copy canvas content
                        // doctypeString: '...',       // enter a different doctype for older markup
                        removeScripts: true,        // remove script tags from print content
                        copyTagClasses: false,      // copy classes from the html & body tag
                        beforePrintEvent: null,     // function for printEvent in iframe
                        beforePrint: null,          // function called before iframe is filled
                        afterPrint: null,           // function called before iframe is removed
                    });
                },
                //-------------------------------------------------------------------------------------------
                getCantidadCaracteres(str_contenido = '')
                {
                    var cantidad    =   0;

                    if(!str_contenido)
                        return cantidad;

                    if(str_contenido.trim().length)
                        cantidad    =   str_contenido.trim().length;

                    return cantidad;
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                refrescarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                    me.cargarUsuario();
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                strCapitalize(str_texto)
                {
                    if (!str_texto) return '';

                    str_texto    = str_texto.toString();
                    var splitStr = str_texto.toLowerCase().split(' ');

                    for (var i = 0; i < splitStr.length; i++) {
                        splitStr[i] = splitStr[i].charAt(0).toUpperCase() + splitStr[i].substring(1);
                    }

                    return splitStr.join(' ');
                },
                //-------------------------------------------------------------------------------------------
                inArray(needle, haystack) 
                {
                    var length = haystack.length;
                    for(var i = 0; i < length; i++) {
                        if(haystack[i] == needle) return true;
                    }
                    return false;
                },
                //-------------------------------------------------------------------------------------------
                cerrarModal(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'telefonista':
                        {


                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarUsuario()
                {
                    let me      =   this;
                    var ruta    =   '/info/usuario';
                    me.arr_usuario  =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta     =   response.data;
                        me.arr_usuario    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTelefonistas()
                {
                    let me      =   this;
                    var ruta    =   '/listado/telefonistas';
                    me.arr_telefonista  =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_telefonista      =   respuesta;
                        me.list_telefonista     =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          =   this;
                    var ruta        =   '/gestion/encuestador';

                    axios.post(ruta,{
                        'page'              :   page,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_index        =   respuesta.info.data ;
                        me.pagination       =   respuesta.pagination;
                        me.rows             =   respuesta.info.data;
                        me.nr_cantidad_ticket   =   respuesta.nr_cantidad_ticket;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;                    

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarDatos(modelo)
                {
                    let me  =   this;

                    switch(modelo)
                    {
                        case 'telefonista':
                        {
                            me.nr_telefonista   =   null;
                            me.tp_distribucion  =   0;
                            me.nr_distribucion  =   0;
                            me.nr_registro      =   0;
                            me.nm_registro      =   '';

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                ensamblarDatos(accion)
                {
                    let me          =   this;
                    var ruta        =   '';
                    var titulo      =   '';
                    var tiempo      =   3000;
                    var error       =   0;
                    var formData    =   new FormData();
                    var fc_format   =   'YYYY-MM-DD HH:mm:ss'; // 'DD-MM-YYYY HH:mm:ss';
                    //----------------------------------------------------------------
                    switch(accion)
                    {
                        case 'solicitud':
                        {
                            titulo  =   'Registrar Solicitud';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                // ruta    =   '/';                            
                                // me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                //formData.append('nm_direccion', me.getLabel(me.nr_direccion));
                                //------------------------------------
                                // me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'agregar':
                        {
                            titulo  =   'Agregar Telefonista a la Encuesta de Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                me.btn_envio    =   1;
                                //------------------------------------
                                ruta    =   '/encuestador/store';
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_telefonista', me.getValue(me.nr_telefonista));
                                formData.append('nm_telefonista', me.getLabel(me.nr_telefonista));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'distribuir':
                        {
                            titulo  =   'Realizando Distribución de Ticket de Atención Vecino';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                me.btn_distribuir   =   1;
                                //------------------------------------
                                ruta    =   '/encuestador/distribucion/ticket';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('tp_distribucion', me.tp_distribucion);
                                formData.append('nr_distribucion', me.nr_distribucion);
                                formData.append('nr_telefonista', me.getValue(me.nr_telefonista));
                                formData.append('nm_telefonista', me.getLabel(me.nr_telefonista));
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'quitar':
                        {
                            titulo  =   'Agregar Telefonista a la Encuesta de Servicio';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/encuestador/delete';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('nr_telefonista', me.nr_registro);
                                formData.append('nm_telefonista', me.nm_registro);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                        case 'asignar':
                        {
                            titulo  =   'Asignación de Cantidad de Ticket';
                            tiempo  =   3000;
                            error   =   me.validarDatos(accion);

                            if(error == 1)
                                me.desplegarVentana('warning',titulo,'Favor revisar los campos requeridos');
                            else
                            {
                                //------------------------------------
                                ruta    =   '/encuestador/distribucion/ticket';                            
                                me.zonaDeEspera(titulo, tiempo);
                                //------------------------------------
                                formData.append('tp_distribucion', me.tp_distribucion);
                                formData.append('nr_distribucion', me.nr_distribucion);
                                formData.append('nr_telefonista', me.nr_registro);
                                formData.append('nm_telefonista', me.nm_registro);
                                //------------------------------------
                                me.registrarDatos(ruta, formData);
                                //------------------------------------
                            }

                            break;
                        }
                    }
                    //----------------------------------------------------------------
                },
                //-------------------------------------------------------------------------------------------
                validarDatos(tp_validacion)
                {
                    let me          =   this;
                    var error       =   0;
                    me.arr_valida   =   [];    
                    me.arr_form     =   {}; 
                    me.str_msj      =   '';

                    switch(tp_validacion)
                    {
                        case 'agregar':
                        {
                            if(me.getValue(me.nr_telefonista) == 0)
                                me.arr_form.nr_telefonista  =   'No se encuentra ID de Telefonista';

                            break;
                        }
                        case 'distribuir':
                        {
                            if(me.tp_distribucion == 0)
                                me.arr_form.tp_distribucion     =   'Debe seleccionar el tipo de distribución de ticket';

                            if(me.tp_distribucion == 3 || me.tp_distribucion == 4)
                            {
                                if(me.getValue(me.nr_telefonista) == 0)
                                    me.arr_form.nr_telefonista  =   'No se encuentra ID de Telefonista';

                                if(me.nr_distribucion == 0)
                                    me.arr_form.nr_distribucion =   'Debe indicar la cantidad de Ticket a Distribuir';
                            }

                            break;
                        }
                        case 'quitar':
                        {
                            if(me.nr_registro == 0)
                                me.arr_form.nr_registro     =   'No se encuentra ID de Telefonista';

                            if(me.nm_registro == '')
                                me.arr_form.nm_registro     =   'No se encuestra Nombre del Telefonista';

                            break;
                        }
                        case 'asignar':
                        {
                            if(me.nr_registro == 0)
                                me.arr_form.nr_registro     =   'No se encuentra ID de Telefonista';

                            if(me.nm_registro == '')
                                me.arr_form.nm_registro     =   'No se encuestra Nombre del Telefonista';

                            if(me.nr_distribucion == 0)
                                me.arr_form.nr_distribucion =   'Debe Indicar la Cantidad de Ticket a Asignar';

                            if(me.nr_distribucion > me.nr_cantidad_ticket)
                                me.arr_form.nr_distribucion =   'La cantidad de ticket a asignar NO debe superar la cantidad disponible';

                            break;
                        }
                    }

                    if(Object.keys(me.arr_form).length != 0)
                        error   =   1;

                    return error;
                },
                //-------------------------------------------------------------------------------------------
                registrarDatos(ruta, formData)
                {
                    let me              =   this;
                    var tp_icon         =   '';
                    var titulo          =   '';
                    var mensaje         =   '';
                    var error           =   '';

                    axios.post(ruta, formData, {
                        headers: {'Content-Type': 'multipart/form-data'}
                    }).then(function (response) 
                    {
                        var result  =   response.data;                       
                        tp_icon     =   result.tp_icon;
                        titulo      =   result.title;
                        mensaje     =   result.msj;
                        error       =   result.error;

                        me.desplegarVentana(tp_icon, titulo, mensaje);

                        //Limpiar Modelos
                        if(error == 0)
                        {
                            me.limpiarDatos('telefonista');
                            me.refrescarDatos();
                        }

                        me.btn_envio        =   0;
                        me.btn_distribuir   =   0;
                    })
                    .catch(function (error) 
                    {
                        me.btn_envio        =   0;
                        me.btn_distribuir   =   0;

                        if (error.response.status == 422)
                            me.arr_valida   =   error.response.data.errors;
                        /*// Formato de Archivo Incorrecto
                        if (error.response.status == 413)
                        {
                            //------------------------------
                        }
                        */
                    });
                },
                //-------------------------------------------------------------------------------------------
                abrirModal(modelo, accion, data = [])
                {
                    let me      =   this;                    

                    switch(modelo)
                    {
                        case 'telefonista':
                        {
                            switch(accion)
                            {
                                case 'distribuir_equidad':
                                {
                                    me.tp_distribucion  =   1;
                                    me.nr_distribucion  =   0;
                                    me.nr_registro      =   0;
                                    me.nm_registro      =   '';
                                    me.ensamblarDatos('distribuir');

                                    break;
                                }
                                case 'distribuir_igualdad':
                                {
                                    me.tp_distribucion  =   2;
                                    me.nr_distribucion  =   0;
                                    me.nr_registro      =   0;
                                    me.nm_registro      =   '';
                                    me.ensamblarDatos('distribuir');

                                    break;
                                }
                                case 'quitar':
                                {
                                    me.nr_registro      =   data.id_telefonista;
                                    me.nm_registro      =   data.nm_telefonista;
                                    me.ensamblarDatos('quitar');

                                    break;
                                }
                                case 'modal_asignacion':
                                {
                                    me.btn_asignar      =   0;
                                    me.arr_form         =   {};
                                    me.tp_distribucion  =   3;
                                    me.nr_distribucion  =   0;
                                    me.nr_registro      =   data.id_telefonista;
                                    me.nm_registro      =   data.nm_telefonista;
                                    
                                    $('#modal_asignacion').modal('show');

                                    break;
                                }
                            }

                            break;
                        }
                    }
                },
                //-------------------------------------------------------------------------------------------
                zonaDeEspera(titulo, tiempo)
                {
                    Swal.fire({
                        title : '<h5>'+titulo+'</h5>',
                        html: '<strong> </strong>',
                        showConfirmButton: false,
                        timer: tiempo,
                        onBeforOpen: () => {
                            Swal.showLoading()
                        },
                    }).then((result) => {
                        if(result.dismiss == Swal.DismissReason.timer)
                        {
                            //----------------------------------------
                        }
                    });
                },
                //-------------------------------------------------------------------------------------------
                desplegarVentana(tp_icon, titulo, mensaje, tp_btn = 1)
                {
                    Swal.fire({
                        icon: tp_icon,
                        title: titulo,
                        html: mensaje,
                        backdrop:false,
                        showConfirmButton: tp_btn
                    });                       
                },
                //-------------------------------------------------------------------------------------------
                setStyleCalificacion(str_campo)
                {
                    let me  =   this;

                    $(function() {
                        $('#'+str_campo).barrating('show', {
                            theme: 'fontawesome-stars',
                            showValues: false,
                            onSelect: function(value, text, event) {
                                if (typeof(event) !== 'undefined') {
                                    // rating was selected by a user
                                    console.log(event.target);
                                    console.log(value);
                                    console.log(text);
                                } else {
                                    // rating was selected programmatically
                                    // by calling `set` method
                                }
                            }
                        });
                    });
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarUsuario();
                me.cargarTelefonistas();
                me.cargarDatos();
            }
        });
    </script>

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            /*----- Inicio - Modal -----*/
            $('#modal_estadistica').modal({backdrop: 'static', keyboard: false});
        });
        //-----------------------------------------------------------------
        function justNumbers(e)
        {
            var keynum = window.event ? window.event.keyCode : e.which;
            if (keynum == 8)
                return true;

            return /\d/.test(String.fromCharCode(keynum));
        }
        //-----------------------------------------------------------------
        function Rut(texto)
        { 
            var tmpstr = "";

            for ( i=0; i < texto.length ; i++ )   
                if ( texto.charAt(i) != ' ' && texto.charAt(i) != '.' && texto.charAt(i) != '-' )
                    tmpstr = tmpstr + texto.charAt(i);

            texto = tmpstr; 
            largo = texto.length; 

            if ( largo < 2 ) 
                return false; 

            for (i=0; i < largo ; i++ )    
                if (texto.charAt(i) !="0" && texto.charAt(i) != "1" && texto.charAt(i) !="2" && texto.charAt(i) != "3" && 
                    texto.charAt(i) != "4" && texto.charAt(i) !="5" && texto.charAt(i) != "6" && texto.charAt(i) != "7" && 
                    texto.charAt(i) !="8" && texto.charAt(i) != "9" && texto.charAt(i) !="k" && texto.charAt(i) != "K")   
                    return false;

            var invertido = "";

            for ( i=(largo-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + texto.charAt(i);

            var dtexto = "";  
            dtexto = dtexto + invertido.charAt(0);  
            dtexto = dtexto + '-';  
            cnt = 0;  

            for ( i=1,j=2; i<largo; i++,j++ ) 
            { 
                if ( cnt == 3 )   
                {     
                    dtexto = dtexto + '.';      
                    j++;      
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt = 1;    
                }   
                else    
                {       
                    dtexto = dtexto + invertido.charAt(i);      
                    cnt++;    
                } 
            } 

            invertido = "";

            for ( i=(dtexto.length-1),j=0; i>=0; i--,j++ )    
                invertido = invertido + dtexto.charAt(i);

            if (revisarDigito2(texto))
                return  invertido.toUpperCase();

            return false;
        }
        //-----------------------------------------------------------------
        function formatoMail(valor)
        {
            if (/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(valor))
                return true;
            else
                return false;
        }
        //-----------------------------------------------------------------
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atencion_vecino\resources\views/administrador/gestion_encuestadores_administrador.blade.php ENDPATH**/ ?>