<?php $__env->startSection('body'); ?>
<div class="page-content">
    <div class="container-fluid" id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">DashBoard</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">DashBoard</a></li>
                            <li class="breadcrumb-item active">Redes Sociales</li>
                        </ol>
                    </div>
                </div>

                <!-- Filtros Especificos -->
                <div class="row mb-3 not-print">
                    <div class="col-lg-12 col-md-12 col-sm-12" style="text-align:right">
                        <button id="btn_actualizar" class="btn btn-primary btn_activo" @click="cargarDatos();">
                            <i class="fas fa-sync"></i> Actualizar
                        </button>

                        <button class="btn btn-primary btn_activo" id="btn_filtrar_datos">
                            <i class="fas fa-search"></i> Filtrar Datos
                        </button>
                    </div>                        
                </div>

                <!-- Filtros -->
                <div class="collapse" id="filtrar_datos">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <div class="col-md-12 col-sm-12 text-center">
                                <h5 style="color:white;">Filtros de Exportación</h5>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row ml-2 mr-2">
                                <!-- Dirección Municipal -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Dirección Municipal :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_direccion"
                                            :options="arr_direccion" 
                                            @select="asyncDeptos" 
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Dirección Municipal"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Depto Municipal -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Depto Municipal :
                                        </label>
                                        <multiselect 
                                            :show-labels="false"
                                            :searchable="true"
                                            v-model="fl_depto"
                                            :options="arr_depto" 
                                            @select="asyncServicios" 
                                            :multiple="false"
                                            :showNoOptions=false
                                            placeholder="Depto Municipal"
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                                <!-- Servicio -->
                                <div class="col-md-4 col-sm-6 mt-2">
                                    <div class="form-group">
                                        <label class="form-control-label" for="text-input">
                                            Servicio :
                                        </label>
                                        <multiselect
                                            :show-labels="false" 
                                            :searchable="true" 
                                            v-model="fl_servicio" 
                                            :options="arr_servicio" 
                                            :multiple="false" 
                                            :showNoOptions="false" 
                                            placeholder="Servicio" 
                                            label="label" track-by="label">
                                                <span slot="noResult">No se han encontrado resultados</span>
                                        </multiselect>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="float: right;">
                                <button @click="limpiarFiltros()" type="button" class="btn btn-warning btn-sm btn_activo" style="color: white;">
                                    <i class="fas fa-undo"></i> Quitar Filtros
                                </button>&nbsp;
                                <button @click="filtrarDatos()" type="button" class="btn btn-primary btn-sm btn_activo"><i class="fas fa-search"></i>
                                    Filtrar Búsqueda
                                </button>
                                <button class="btn btn-secondary btn-sm btn_activo" id="close_filtrar_datos">
                                    Cerrar Filtro
                                </button>
                            </div>
                        </div>
                    </div>
                </div>                    

                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-sm-6">
                                <div class="card bg-info">
                                    <div class="card-body text-white h4">
                                        Total Redes Sociales <br>
                                        valor : {{ arr_totales.nr_total }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-6">
                                <div class="card bg-info">
                                    <div class="card-body text-white h4">
                                        En Gestion <br>
                                        valor : {{ arr_totales.nr_gestion }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-6">
                                <div class="card bg-info">
                                    <div class="card-body text-white h4">
                                        En Revisión <br>
                                        valor : {{ arr_totales.nr_revision }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-6">
                                <div class="card bg-info">
                                    <div class="card-body text-white h4">
                                        Cerrado <br>
                                        valor : {{ arr_totales.nr_publicado }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <div id="data_chart" style="margin-left:0%;width:1500px;height:1600px;border:2px solid black"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script >
        Vue.component('vue-multiselect', window.VueMultiselect.default);

        var app = new Vue({
            el: '#app',
            data: {                
                //-------------------------------------
                pagination                  : {
                    'total' : 0,
                    'current_page' : 0,
                    'per_page' : 0,
                    'last_page' : 0,
                    'from' : 0,
                    'to' : 0,
                },
                //-------------------------------------
                offset                      :   3,
                //-------------------------------------
                //-------------------------------------
                fl_mostrar                  :   0,
                fl_direccion                :   [],
                fl_depto                    :   [],
                fl_servicio                 :   [],
                fl_macrozona                :   [],
                fl_unidadvecinal            :   [],
                fl_ticket                   :   [],
                fl_persona                  :   [],
                fl_motivo                   :   [],
                fl_ubicacion                :   [],
                //-------------------------------------
                tp_criterio                 :   'created_at',
                tp_orden                    :   'DESC',
                //-------------------------------------
                arr_direccion               :   [],
                arr_depto                   :   [],
                arr_servicio                :   [],
                arr_motivo                  :   [],
                arr_macrozona               :   [],
                arr_unidadvecinal           :   [],
                arr_ticket                  :   [],
                arr_persona                 :   [],
                arr_ubicaciones             :   [],
                //-------------------------------------
                arr_mostrar                 :   [
                    {
                        'value'     :   0,
                        'label'     :   'Todos',
                    },
                    {
                        'value'     :   1,
                        'label'     :   'Ingresada',
                    },
                    {
                        'value'     :   2,
                        'label'     :   'Por Asignar',
                    }, 
                    {
                        'value'     :   3,
                        'label'     :   'En Gestión',
                    },
                    {
                        'value'     :   4,
                        'label'     :   'En Revisión',
                    },
                    {
                        'value'     :   5,
                        'label'     :   'Cerrado',
                    },
                    {
                        'value'     :   6,
                        'label'     :   'Terminado',
                    },
                    {
                        'value'     :   7,
                        'label'     :   'Anulada',
                    },
                ],
                //-------------------------------------
                fl_mostrar                  :   0,
                arr_dashborad               :   [],
                arr_grafico                 :   [],
                arr_totales                 :   {
                    'nr_global': 0,
                    'nr_total': 0,
                    'nr_gestion': 0,
                    'nr_revision': 0,
                    'nr_publicado': 0
                },
                //-------------------------------------
            },

            components: {
                //-------------------------------------------------------------------------------------------
                Multiselect: window.VueMultiselect.default
                //-------------------------------------------------------------------------------------------
            },

            filters:{
                //-------------------------------------------------------------------------------------------
                formatDate: function (fecha)
                {
                    if(fecha)
                        return moment(String(fecha)).format('DD-MM-YYYY')
                },

                formatDateTime: function (fecha)
                {
                    if(fecha)
                    {
                        return moment(String(fecha)).format('DD-MM-YYYY HH:mm')
                    }
                },
                //-------------------------------------------------------------------------------------------
            },

            computed:{
                //-------------------------------------------------------------------------------------------
                isActivedPagination: function()
                {
                    return this.pagination.current_page;
                },
                //-------------------------------------------------------------------------------------------
                pagesNumber: function()
                {
                    if(!this.pagination.to) {
                        return [];
                    }

                    var from = this.pagination.current_page - this.offset;
                    if(from < 1) {
                        from = 1;
                    }

                    var to = from + (this.offset * 2);
                    if(to >= this.pagination.last_page){
                        to = this.pagination.last_page;
                    }

                    var pagesArray = [];
                    while(from <= to) {
                        pagesArray.push(from);
                        from++;
                    }
                    return pagesArray;
                },
                //-------------------------------------------------------------------------------------------
            },

            methods: {
                //-------------------------------------------------------------------------------------------
                imprimir()
                {
                    $("#modal_historial").printThis({
                        debug: false,               // show the iframe for debugging
                        importCSS: true,            // import parent page css
                        importStyle: true,          // import style tags
                        printContainer: false,      // print outer container/$.selector
                        loadCSS: "",                // path to additional css file - use an array [] for multiple
                        pageTitle: "",              // add title to print page
                        removeInline: true,        // remove inline styles from print elements
                        removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                        printDelay: 333,            // variable print delay
                        header: null,               // prefix to html
                        footer: null,               // postfix to html
                        base: 'https://atencionvecino.lascondes.cl/',                // preserve the BASE tag or accept a string for the URL
                        formValues: true,           // preserve input/form values
                        canvas: false,              // copy canvas content
                        // doctypeString: '...',       // enter a different doctype for older markup
                        removeScripts: true,        // remove script tags from print content
                        copyTagClasses: false,      // copy classes from the html & body tag
                        beforePrintEvent: null,     // function for printEvent in iframe
                        beforePrint: null,          // function called before iframe is filled
                        afterPrint: null,           // function called before iframe is removed
                    });
                },
                //-------------------------------------------------------------------------------------------
                cambiarPagina(page)
                {
                    let me  =   this;
                    me.pagination.current_page = page;
                    me.cargarDatos(page);
                },
                //-------------------------------------------------------------------------------------------
                getLabel(data)
                {
                    var valor   =   '';

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.label;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                getValue(data)
                {
                    var valor   =   0;

                    if (!(typeof data === "undefined") && !(data === null))
                    {
                        valor   =   data.value;
                    }

                    return valor;
                },
                //-------------------------------------------------------------------------------------------
                filtrarDatos()
                {
                    let me  =   this;
                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                limpiarFiltros()
                {
                    let me  =   this;

                    me.fl_direccion         =   [];
                    me.fl_depto             =   [];
                    me.fl_servicio          =   [];
                    me.fl_macrozona         =   [];
                    me.fl_unidadvecinal     =   [];
                    me.fl_ticket            =   [];
                    me.arr_depto            =   [];
                    me.arr_servicio         =   [];
                    me.fl_ubicacion         =   [];
                    me.fl_motivo            =   [];
                    me.fl_persona           =   [];

                    me.cargarDatos();
                },
                //-------------------------------------------------------------------------------------------
                asyncDeptos(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_direccion     =   item;
                        me.cargarDeptosMunicipales(0, me.getValue(me.fl_direccion));                        
                        me.arr_servicio     =   [];
                        me.fl_depto         =   [];
                        me.fl_servicio      =   [];
                    }
                    else
                    {
                        me.fl_depto         =   [];
                        me.fl_servicio      =   [];
                        me.arr_depto        =   [];
                        me.arr_servicio     =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                asyncServicios(item)
                {
                    let me  =   this;

                    if(item)
                    {
                        me.fl_depto     =   item;
                        me.cargarServicios(me.getValue(me.fl_direccion), me.getValue(me.fl_depto));
                        me.fl_servicio  =   [];
                    }
                    else
                    {
                        me.fl_servicio  =   [];
                    }
                },
                //-------------------------------------------------------------------------------------------
                cargarDireccionesMunicipales()
                {
                    let me      =   this;
                    var ruta    =   '/listado/direcciones_municipales';
                    me.arr_direccion    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_direccion    =   respuesta.direcciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDeptosMunicipales(tp_filtro = 0, nr_direccion)
                {
                    let me      =   this;
                    var ruta    =   '/listado/deptos_municipales';
                    me.arr_depto    =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_depto        =   respuesta.deptos;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarServicios(nr_direccion = 0, nr_depto = 0)
                {
                    let me      =   this;
                    var ruta    =   '/listado/servicios';
                    me.arr_servicio     =   [];

                    axios.post(ruta,{
                        'nr_direccion'      :   nr_direccion,
                        'nr_depto'          :   nr_depto,
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_servicio     =   respuesta;
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMotivo()
                {
                    let me      =   this;
                    var ruta    =   '/motivo/listado';
                    me.arr_motivo   =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta   =   response.data;
                        me.arr_motivo   =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarMacrozona()
                {
                    let me      =   this;
                    var ruta    =   '/listado/macrozona';
                    me.arr_macrozona    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_macrozona    =   respuesta.macrozona;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUnidadVecinal()
                {
                    let me      =   this;
                    var ruta    =   '/listar/unidadvecinales';
                    me.arr_unidadvecinal    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_unidadvecinal    =   respuesta;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarTicket()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ticket';
                    me.arr_ticket    =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta    =   response.data;
                        me.arr_ticket    =   respuesta.ticket;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarUbicaciones()
                {
                    let me      =   this;
                    var ruta    =   '/listado/ubicaciones';
                    me.arr_ubicaciones      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta           =   response.data;
                        me.arr_ubicaciones      =   respuesta.ubicaciones;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarPersonas()
                {
                    let me      =   this;
                    var ruta    =   '/listado/personas';
                    me.arr_persona      =   [];

                    axios.get(ruta).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_persona      =   respuesta.personas;
                    })
                    .catch(function (error){
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarDatos(page = 1)
                {
                    let me          = this;
                    var ruta        = '/dashboard/redes_sociales';
                    me.arr_dashborad    =   [];

                    axios.post(ruta,{
                        'fl_direccion'      :   me.getValue(me.fl_direccion),
                        'fl_depto'          :   me.getValue(me.fl_depto),
                        'fl_servicio'       :   me.getValue(me.fl_servicio),
                    }).then(function (response)
                    {
                        var respuesta       =   response.data;
                        me.arr_dashborad    =   respuesta.datos;
                        me.arr_totales      =   respuesta.totales;
                        me.arr_grafico      =   respuesta.grafico;
                        me.$nextTick(() => {
                            me.cargarGrafico(me.arr_grafico);
                        });
                    }).catch(function (error) {
                        console.log(error);
                    });
                },
                //-------------------------------------------------------------------------------------------
                cargarGrafico(data = [])
                {
                    let me      =   this;
                    var myChart =   echarts.init(document.getElementById('data_chart'));
                    var option  =   {
                                        grid : data.grid,
                                        title: {
                                            text: data.title.text
                                        },
                                        tooltip: {
                                            trigger: 'axis',
                                            axisPointer: {
                                                type: 'shadow'
                                            },
                                        },
                                        xAxis: data.xAxis,
                                        yAxis: data.yAxis,
                                        series: data.series
                                    };                                    

                    console.log('----- Data Grafico -----');
                    console.log(data);

                    myChart.setOption(option);
                },
                //-------------------------------------------------------------------------------------------
            },

            mounted() {
                let me = this;
                me.cargarDireccionesMunicipales();
                me.cargarDeptosMunicipales(0,0);
                me.cargarServicios(0,0);
                me.cargarDatos();
            }
        });
    </script>
    

    <script type="text/javascript">
        //-----------------------------------------------------------------
        $(document).ready(function(){
            /*----- Inicio - Filtrar -----*/
            $("#btn_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });

            $("#close_filtrar_datos").click(function () {
                $content = $("#filtrar_datos");
                $content.slideToggle(500, function () {
                    // ---------------------------                    
                });
            });
            /*----- Inicio - Modal -----*/
        });
        //-----------------------------------------------------------------
    </script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('template.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\repositorio\atencion_vecino\resources\views/redes_sociales/dashboard_redes_sociales.blade.php ENDPATH**/ ?>